/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.gui;

import com.cryptomorin.xseries.inventory.XInventoryView;
import fr.skytasul.quests.api.gui.Gui;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGui
implements Gui {
    @Nullable
    private Inventory inventory;

    @Override
    @Nullable
    public Inventory getInventory() {
        return this.inventory;
    }

    @Override
    public final void showInternal(Player player) {
        if (this.inventory == null) {
            this.inventory = this.instanciate(player);
            this.populate(player, this.inventory);
        } else {
            this.refresh(player, this.inventory);
        }
        this.inventory = XInventoryView.of((InventoryView)player.openInventory(this.inventory)).getTopInventory();
    }

    @Override
    public final void reopen(@NotNull Player player, boolean refresh) {
        if (refresh) {
            this.inventory = null;
        }
        this.open(player);
    }

    public final void repopulate(@NotNull Player player) {
        if (this.inventory == null) {
            this.inventory = this.instanciate(player);
        } else {
            this.inventory.clear();
        }
        this.populate(player, this.inventory);
    }

    protected abstract Inventory instanciate(@NotNull Player var1);

    protected abstract void populate(@NotNull Player var1, @NotNull Inventory var2);

    protected void refresh(@NotNull Player player, @NotNull Inventory inventory) {
    }

    @Override
    @NotNull
    public CloseBehavior onClose(@NotNull Player player) {
        return StandardCloseBehavior.CONFIRM;
    }
}

