/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.gui;

import fr.skytasul.quests.api.gui.Gui;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiClickEvent {
    @NotNull
    private final Player player;
    @NotNull
    private final Gui gui;
    @Nullable
    private final ItemStack clicked;
    @Nullable
    private final ItemStack cursor;
    private final int slot;
    @NotNull
    private final ClickType click;
    private boolean cancelled = true;

    public GuiClickEvent(@NotNull Player player, @NotNull Gui gui, @Nullable ItemStack clicked, @Nullable ItemStack cursor, int slot, @NotNull ClickType click) {
        this.player = player;
        this.gui = gui;
        this.clicked = clicked;
        this.cursor = cursor;
        this.slot = slot;
        this.click = click;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public Gui getGui() {
        return this.gui;
    }

    @Nullable
    public ItemStack getClicked() {
        return this.clicked;
    }

    @Nullable
    public ItemStack getCursor() {
        return this.cursor;
    }

    public boolean hasCursor() {
        return this.cursor != null && this.cursor.getType() != Material.AIR;
    }

    public int getSlot() {
        return this.slot;
    }

    @NotNull
    public ClickType getClick() {
        return this.click;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public void reopen() {
        this.gui.reopen(this.player);
    }

    public void close() {
        this.gui.close(this.player);
    }
}

