/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.gui;

import fr.skytasul.quests.api.blocks.BQBlock;
import fr.skytasul.quests.api.comparison.ItemComparisonMap;
import fr.skytasul.quests.api.gui.Gui;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.utils.CountableObject;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface GuiFactory {
    @NotNull
    public Gui createPlayerQuestsMenu(@NotNull Player var1);

    @NotNull
    public Gui createItemSelection(@NotNull Consumer<ItemStack> var1, boolean var2);

    @NotNull
    default public Gui createItemSelection(@NotNull Consumer<ItemStack> callback, Runnable cancel) {
        return this.createItemSelection((ItemStack item) -> {
            if (item == null) {
                cancel.run();
            } else {
                callback.accept((ItemStack)item);
            }
        }, true);
    }

    @NotNull
    public Gui createItemCreator(@NotNull Consumer<ItemStack> var1, boolean var2);

    @NotNull
    public Gui createItemsSelection(@NotNull @NotNull Consumer<@NotNull List<@NotNull ItemStack>> var1, @Nullable @Nullable List<@Nullable ItemStack> var2);

    @NotNull
    public Gui createItemComparisonsSelection(@NotNull ItemComparisonMap var1, @NotNull Runnable var2);

    @NotNull
    public Gui createBlocksSelection(@NotNull Consumer<List<CountableObject.MutableCountableObject<BQBlock>>> var1, @NotNull Collection<CountableObject.MutableCountableObject<BQBlock>> var2);

    @NotNull
    public Gui createNpcSelection(@NotNull Runnable var1, @NotNull Consumer<BqNpc> var2, boolean var3);

    @NotNull
    default public Gui createConfirmation(@Nullable Runnable yes, @Nullable Runnable no, @NotNull String indication, String ... lore) {
        return this.createConfirmation(yes, no, indication, Arrays.asList(lore));
    }

    @NotNull
    public Gui createConfirmation(@Nullable Runnable var1, @Nullable Runnable var2, @NotNull String var3, @Nullable @Nullable List<@Nullable String> var4);

    @NotNull
    public Gui createEntityTypeSelection(@NotNull Consumer<EntityType> var1, @Nullable Predicate<@NotNull EntityType> var2);

    @NotNull
    public Gui createQuestSelection(@NotNull Consumer<Quest> var1, @Nullable Runnable var2, @NotNull Collection<Quest> var3);

    @NotNull
    public Gui createPlayerQuestSelection(@NotNull Player var1, @NotNull Collection<Quest> var2);
}

