/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.gui;

import com.cryptomorin.xseries.XEnchantment;
import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.utils.ChatColorUtils;
import fr.skytasul.quests.api.utils.MinecraftNames;
import fr.skytasul.quests.api.utils.MinecraftVersion;
import fr.skytasul.quests.api.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.Nullable;

public final class ItemUtils {
    private static final int LORE_LINE_LENGTH = 40;
    private static final int LORE_LINE_LENGTH_CRITICAL = 1000;

    private ItemUtils() {
    }

    public static ItemStack item(XMaterial type, String name, String ... lore) {
        if (!type.isSupported()) {
            QuestsPlugin.getPlugin().getLogger().warning("Trying to create an item for an unsupported material " + type.name());
            type = XMaterial.SPONGE;
        }
        if (!type.get().isItem()) {
            type = XMaterial.SPONGE;
        }
        ItemStack is = type.parseItem();
        ItemMeta im = is.getItemMeta();
        ItemUtils.addSpecificFlags(im, is.getType());
        is.setItemMeta(ItemUtils.applyMeta(im, name, lore));
        return is;
    }

    public static ItemStack item(XMaterial type, String name, List<String> lore) {
        if (!type.isSupported()) {
            QuestsPlugin.getPlugin().getLogger().warning("Trying to create an item for an unsupported material " + type.name());
            type = XMaterial.SPONGE;
        }
        if (!type.get().isItem()) {
            type = XMaterial.SPONGE;
        }
        ItemStack is = type.parseItem();
        ItemMeta im = is.getItemMeta();
        ItemUtils.addSpecificFlags(im, is.getType());
        is.setItemMeta(ItemUtils.applyMeta(im, name, lore));
        return is;
    }

    public static ItemStack skull(String name, String skull, String ... lore) {
        ItemStack is = XMaterial.PLAYER_HEAD.parseItem();
        SkullMeta im = (SkullMeta)is.getItemMeta();
        if (skull != null) {
            im.setOwner(skull);
        }
        is.setItemMeta(ItemUtils.applyMeta((ItemMeta)im, name, lore));
        return is;
    }

    private static ItemMeta applyMeta(ItemMeta im, String name, Object lore) {
        String[] loreArray;
        List<String> editLore = null;
        if (name != null) {
            editLore = ChatColorUtils.wordWrap(name, 40, 1000);
            if (editLore.isEmpty()) {
                name = "";
                editLore = null;
            } else if (editLore.size() == 1) {
                name = editLore.get(0);
                editLore = null;
            } else {
                name = editLore.remove(0);
            }
            im.setDisplayName(name);
        }
        if (lore instanceof List) {
            List<String> loreList = (List<String>)lore;
            if (!loreList.isEmpty()) {
                if (editLore != null) {
                    editLore.addAll((Collection<String>)loreList);
                    loreList = editLore;
                }
                im.setLore(ItemUtils.getLoreLines(loreList));
                return im;
            }
        } else if (lore instanceof String[] && (loreArray = (String[])lore).length != 0) {
            if (editLore != null) {
                editLore.addAll(Arrays.asList(loreArray));
                im.setLore(ItemUtils.getLoreLines(editLore));
            } else {
                im.setLore(ItemUtils.getLoreLines(loreArray));
            }
            return im;
        }
        if (editLore != null) {
            im.setLore(ItemUtils.getLoreLines(editLore));
        }
        return im;
    }

    public static ItemStack nameAndLore(ItemStack is, String name, String ... lore) {
        is.setItemMeta(ItemUtils.applyMeta(is.getItemMeta(), name, lore));
        return is;
    }

    public static ItemStack nameAndLore(ItemStack is, String name, List<String> lore) {
        is.setItemMeta(ItemUtils.applyMeta(is.getItemMeta(), name, lore));
        return is;
    }

    public static ItemStack clearVisibleAttributes(ItemStack is) {
        ItemMeta im = is.getItemMeta();
        im.setDisplayName(null);
        im.setLore(null);
        ItemUtils.addSpecificFlags(im, is.getType());
        is.setItemMeta(im);
        return is;
    }

    public static ItemMeta addSpecificFlags(ItemMeta im, Material material) {
        if (im.hasEnchants()) {
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (im.isUnbreakable()) {
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        }
        if (material.getMaxDurability() != 0 || im.hasAttributeModifiers()) {
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        if (im instanceof BookMeta || im instanceof PotionMeta || im instanceof EnchantmentStorageMeta || im instanceof KnowledgeBookMeta) {
            im.addItemFlags(new ItemFlag[]{Utils.valueOfEnum(ItemFlag.class, "HIDE_POTION_EFFECTS", "HIDE_ADDITIONAL_TOOLTIP")});
        }
        if (im instanceof LeatherArmorMeta) {
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
        }
        return im;
    }

    public static ItemStack lore(ItemStack is, String ... lore) {
        ItemMeta im = is.getItemMeta();
        im.setLore(ItemUtils.getLoreLines(lore));
        is.setItemMeta(im);
        return is;
    }

    public static ItemStack lore(ItemStack is, List<String> lore) {
        ItemMeta im = is.getItemMeta();
        im.setLore(ItemUtils.getLoreLines(lore));
        is.setItemMeta(im);
        return is;
    }

    public static ItemStack loreOptionValue(ItemStack is, @Nullable Object value) {
        return ItemUtils.lore(is, QuestOption.formatNullableValue(value));
    }

    private static List<String> getLoreLines(String ... lore) {
        if (lore != null) {
            ArrayList<String> finalLines = new ArrayList<String>();
            if (lore != null) {
                for (int i = 0; i < lore.length; ++i) {
                    String line = lore[i];
                    if (line == null) {
                        if (i + 1 == lore.length) break;
                        finalLines.add("\u00a7a");
                        continue;
                    }
                    finalLines.addAll(ChatColorUtils.wordWrap(line, 40, 1000));
                }
            }
            return finalLines;
        }
        return Collections.emptyList();
    }

    private static List<String> getLoreLines(List<String> lore) {
        if (lore != null) {
            ArrayList<String> finalLines = new ArrayList<String>();
            if (lore != null) {
                for (int i = 0; i < lore.size(); ++i) {
                    String line = lore.get(i);
                    if (line == null) {
                        if (i + 1 == lore.size()) break;
                        finalLines.add("\u00a7a");
                        continue;
                    }
                    finalLines.addAll(ChatColorUtils.wordWrap(line, 40, 1000));
                }
            }
            return finalLines;
        }
        return Collections.emptyList();
    }

    public static ItemStack loreAdd(ItemStack is, String ... add) {
        ItemMeta im = is.getItemMeta();
        if (!im.hasLore()) {
            im.setLore(ItemUtils.getLoreLines(add));
            is.setItemMeta(im);
            return is;
        }
        List ls = im.getLore();
        ls.addAll(Arrays.asList(add));
        im.setLore(ItemUtils.getLoreLines(ls));
        is.setItemMeta(im);
        return is;
    }

    public static String[] getLore(ItemStack is) {
        if (!is.hasItemMeta() || !is.getItemMeta().hasLore()) {
            return null;
        }
        return is.getItemMeta().getLore().toArray(new String[0]);
    }

    public static ItemStack owner(ItemStack is, String ownerName) {
        Validate.isTrue((boolean)(is.getItemMeta() instanceof SkullMeta), (String)"ItemStack must be a Skull");
        SkullMeta im = (SkullMeta)is.getItemMeta();
        im.setOwner(ownerName);
        is.setItemMeta((ItemMeta)im);
        return is;
    }

    public static String getOwner(ItemStack is) {
        if (!is.getType().name().equals("SKULL_ITEM") && !is.getType().name().equals("PLAYER_HEAD")) {
            return null;
        }
        return ((SkullMeta)is.getItemMeta()).getOwner();
    }

    public static ItemStack name(ItemStack is, String name) {
        ItemMeta im = is.getItemMeta();
        im.setDisplayName(name);
        is.setItemMeta(im);
        return is;
    }

    public static ItemStack nameAdd(ItemStack is, String add) {
        return ItemUtils.name(is, ItemUtils.getName(is) + add);
    }

    public static String getName(ItemStack is) {
        return ItemUtils.getName(is, false);
    }

    public static String getName(ItemStack is, boolean format) {
        if (is == null) {
            return null;
        }
        if (is.hasItemMeta()) {
            ItemMeta meta = is.getItemMeta();
            if (meta.hasDisplayName()) {
                return meta.getDisplayName();
            }
            if (MinecraftVersion.isHigherThan(20, 5) && meta.hasItemName()) {
                return meta.getItemName();
            }
        }
        return format ? MinecraftNames.getMaterialName(is) : XMaterial.matchXMaterial((ItemStack)is).name();
    }

    public static boolean hasEnchant(ItemStack is, Enchantment en) {
        return is.getItemMeta().hasEnchant(en);
    }

    public static ItemStack addEnchant(ItemStack is, Enchantment en, int level) {
        ItemMeta im = is.getItemMeta();
        if (im.addEnchant(en, level, true)) {
            is.setItemMeta(im);
        }
        return is;
    }

    public static ItemStack removeEnchant(ItemStack is, Enchantment en) {
        ItemMeta im = is.getItemMeta();
        if (im.removeEnchant(en)) {
            is.setItemMeta(im);
        }
        return is;
    }

    public static boolean isGlittering(ItemStack is) {
        ItemMeta im = is.getItemMeta();
        return MinecraftVersion.isHigherThan(20, 6) && im.hasEnchantmentGlintOverride() && im.getEnchantmentGlintOverride() != false || im.hasEnchants();
    }

    public static void setGlittering(ItemStack is, boolean glitter) {
        ItemMeta im = is.getItemMeta();
        if (MinecraftVersion.isHigherThan(20, 6)) {
            im.setEnchantmentGlintOverride(glitter ? Boolean.TRUE : null);
        } else if (glitter) {
            im.addEnchant(XEnchantment.UNBREAKING.getEnchant(), 0, true);
            im.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        } else {
            im.removeEnchant(XEnchantment.UNBREAKING.getEnchant());
        }
        is.setItemMeta(im);
    }

    public static ItemStack itemSeparator(DyeColor color) {
        return ItemUtils.item((XMaterial)XMaterial.matchXMaterial((String)(color.name() + "_STAINED_GLASS_PANE")).get(), "\u00a77", new String[0]);
    }

    public static ItemStack itemSwitch(String name, boolean enabled, String ... lore) {
        return ItemUtils.item(enabled ? XMaterial.LIME_DYE : XMaterial.GRAY_DYE, (enabled ? "\u00a7a" : "\u00a77") + name, lore);
    }

    public static boolean toggleSwitch(ItemStack itemSwitch) {
        String name = ItemUtils.getName(itemSwitch);
        boolean toggled = name.charAt(1) != 'a';
        ItemUtils.setSwitch(itemSwitch, toggled);
        return toggled;
    }

    public static ItemStack setSwitch(ItemStack itemSwitch, boolean enable) {
        if (itemSwitch == null) {
            return null;
        }
        String name = ItemUtils.getName(itemSwitch);
        ItemUtils.name(itemSwitch, (enable ? "\u00a7a" : "\u00a77") + name.substring(2));
        itemSwitch.setType(enable ? XMaterial.LIME_DYE.get() : XMaterial.GRAY_DYE.get());
        return itemSwitch;
    }
}

