/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.gui;

import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bukkit.event.inventory.ClickType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoreBuilder {
    private static final List<ClickType> ORDERED_CLICKS = Arrays.asList(ClickType.RIGHT, ClickType.LEFT, ClickType.SHIFT_RIGHT, ClickType.SHIFT_LEFT);
    private static final Comparator<ClickType> CLICKS_COMPARATOR = Comparator.comparingInt(click -> {
        int i = ORDERED_CLICKS.indexOf(click);
        if (i != -1) {
            return i;
        }
        return click.ordinal() + ORDERED_CLICKS.size();
    });
    private List<String> description = new ArrayList<String>(5);
    private Map<ClickType, String> clicks = new TreeMap<ClickType, String>(CLICKS_COMPARATOR);

    @NotNull
    public LoreBuilder addDescriptionRaw(@Nullable String line) {
        this.description.add(line);
        return this;
    }

    @NotNull
    public LoreBuilder addDescription(@Nullable String line) {
        this.addDescriptionRaw(QuestOption.formatDescription(line));
        return this;
    }

    @NotNull
    public LoreBuilder addDescriptionAsValue(@Nullable Object value) {
        this.addDescription(QuestOption.formatNullableValue(value));
        return this;
    }

    @NotNull
    public LoreBuilder addClick(@Nullable ClickType click, @NotNull String action) {
        if (click != null) {
            this.clicks.put(click, action);
        }
        return this;
    }

    public @NotNull String @Nullable [] toLoreArray() {
        String[] lore = new String[this.description.size() + 1 + this.clicks.size()];
        int i = 0;
        for (int j = this.description.size() - 1; j >= 0; --j) {
            lore[i++] = this.description.get(j);
        }
        lore[i++] = "";
        for (Map.Entry<ClickType, String> entry : this.clicks.entrySet()) {
            lore[i++] = "\u00a78" + Utils.clickName(entry.getKey()) + " > \u00a77" + entry.getValue();
        }
        return lore;
    }
}

