/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.gui.layout;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.layout.LayoutedClickEvent;
import fr.skytasul.quests.api.gui.layout.LayoutedClickHandler;
import fr.skytasul.quests.api.options.QuestOption;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface LayoutedButton
extends LayoutedClickHandler {
    public void place(@NotNull Inventory var1, int var2);

    default public boolean isValid() {
        return true;
    }

    @NotNull
    public static LayoutedButton create(final @NotNull XMaterial material, final @Nullable String name, final @Nullable List<String> lore, final @NotNull LayoutedClickHandler click) {
        return new ItemButton(){

            @Override
            public void click(@NotNull LayoutedClickEvent event) {
                click.click(event);
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemUtils.item(material, name, lore);
            }
        };
    }

    @NotNull
    public static LayoutedButton create(final @NotNull XMaterial material, final @Nullable String name, final @NotNull Supplier<@Nullable List<String>> lore, final @NotNull LayoutedClickHandler click) {
        return new ItemButton(){

            @Override
            public void click(@NotNull LayoutedClickEvent event) {
                click.click(event);
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemUtils.item(material, name, (List)lore.get());
            }
        };
    }

    @NotNull
    public static LayoutedButton createLoreValue(final @NotNull XMaterial material, final @Nullable String name, final @NotNull Supplier<@Nullable Object> loreValue, final @NotNull LayoutedClickHandler click) {
        return new ItemButton(){

            @Override
            public void click(@NotNull LayoutedClickEvent event) {
                click.click(event);
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                @Nullable T value = loreValue.get();
                return ItemUtils.item(material, name, QuestOption.formatNullableValue(value == null ? null : value.toString()));
            }
        };
    }

    @NotNull
    public static LayoutedButton create(final @NotNull XMaterial material, final @NotNull Supplier<@Nullable String> name, final @NotNull Supplier<@Nullable List<String>> lore, final @NotNull LayoutedClickHandler click) {
        return new ItemButton(){

            @Override
            public void click(@NotNull LayoutedClickEvent event) {
                click.click(event);
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemUtils.item(material, (String)name.get(), (List)lore.get());
            }
        };
    }

    @NotNull
    public static LayoutedButton create(final @NotNull XMaterial material, final @NotNull Supplier<@Nullable String> name, final @Nullable List<String> lore, final @NotNull LayoutedClickHandler click) {
        return new ItemButton(){

            @Override
            public void click(@NotNull LayoutedClickEvent event) {
                click.click(event);
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemUtils.item(material, (String)name.get(), lore);
            }
        };
    }

    @NotNull
    public static LayoutedButton create(final @NotNull @NotNull Supplier<@NotNull XMaterial> material, final @NotNull Supplier<@Nullable String> name, final @NotNull Supplier<@Nullable List<String>> lore, final @NotNull LayoutedClickHandler click) {
        return new ItemButton(){

            @Override
            public void click(@NotNull LayoutedClickEvent event) {
                click.click(event);
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return ItemUtils.item((XMaterial)material.get(), (String)name.get(), (List)lore.get());
            }
        };
    }

    @NotNull
    public static LayoutedButton create(final @NotNull Supplier<@Nullable ItemStack> item, final @NotNull LayoutedClickHandler click) {
        return new ItemButton(){

            @Override
            public void click(@NotNull LayoutedClickEvent event) {
                click.click(event);
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return (ItemStack)item.get();
            }
        };
    }

    @NotNull
    public static LayoutedButton create(final @Nullable ItemStack item, final @NotNull LayoutedClickHandler click) {
        return new ItemButton(){

            @Override
            public void click(@NotNull LayoutedClickEvent event) {
                click.click(event);
            }

            @Override
            @Nullable
            public ItemStack getItem() {
                return item;
            }
        };
    }

    @NotNull
    public static LayoutedButton createSwitch(@NotNull BooleanSupplier stateSupplier, @NotNull String name, @Nullable @Nullable List<@Nullable String> lore, @NotNull LayoutedClickHandler click) {
        return LayoutedButton.create(() -> ItemUtils.itemSwitch(name, stateSupplier.getAsBoolean(), lore.toArray(new String[0])), click);
    }

    public static interface ItemButton
    extends LayoutedButton {
        @Nullable
        public ItemStack getItem();

        @Override
        default public void place(@NotNull Inventory inventory, int slot) {
            inventory.setItem(slot, this.getItem());
        }
    }
}

