/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.gui.layout;

import fr.skytasul.quests.api.gui.AbstractGui;
import fr.skytasul.quests.api.gui.GuiClickEvent;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.gui.layout.LayoutedButton;
import fr.skytasul.quests.api.gui.layout.LayoutedClickEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LayoutedGUI
extends AbstractGui {
    @NotNull
    protected final Map<Integer, LayoutedButton> buttons;
    @NotNull
    protected final CloseBehavior closeBehavior;

    protected LayoutedGUI(@NotNull Map<Integer, LayoutedButton> buttons, @NotNull CloseBehavior closeBehavior) {
        this.buttons = buttons;
        this.closeBehavior = closeBehavior;
    }

    @Override
    protected void populate(@NotNull Player player, @NotNull Inventory inventory) {
        this.buttons.forEach((slot, button) -> {
            if (button.isValid()) {
                button.place(inventory, (int)slot);
            }
        });
    }

    @Override
    public final void onClick(GuiClickEvent event) {
        LayoutedButton button = this.buttons.get(event.getSlot());
        if (button == null || !button.isValid()) {
            return;
        }
        LayoutedClickEvent subEvent = new LayoutedClickEvent(event.getPlayer(), this, event.getClicked(), event.getCursor(), event.getSlot(), event.getClick());
        button.click(subEvent);
        event.setCancelled(subEvent.isCancelled());
    }

    public void refresh(int slot) {
        if (this.getInventory() == null) {
            return;
        }
        LayoutedButton button = this.buttons.get(slot);
        if (button == null || !button.isValid()) {
            this.getInventory().setItem(slot, null);
        } else {
            button.place(this.getInventory(), slot);
        }
    }

    public void refresh(@NotNull LayoutedButton button) {
        if (this.getInventory() == null) {
            return;
        }
        this.buttons.forEach((slot, otherButton) -> {
            if (otherButton.equals(button)) {
                this.refresh((int)slot);
            }
        });
    }

    @Override
    @NotNull
    public CloseBehavior onClose(@NotNull Player player) {
        return this.closeBehavior;
    }

    @NotNull
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<Integer, LayoutedButton> buttons = new HashMap<Integer, LayoutedButton>();
        @Nullable
        private Integer rows = null;
        @Nullable
        private InventoryType type = null;
        @Nullable
        private String name = null;
        @NotNull
        private CloseBehavior closeBehavior = StandardCloseBehavior.CONFIRM;

        private Builder() {
        }

        @NotNull
        public Builder addButton(int slot, @NotNull LayoutedButton button) {
            Validate.isTrue((!this.buttons.containsKey(slot) ? 1 : 0) != 0);
            this.buttons.put(slot, button);
            return this;
        }

        @NotNull
        public Builder setRowNumber(int rows) {
            Validate.isTrue((rows >= 1 ? 1 : 0) != 0);
            if (this.type != null) {
                throw new IllegalStateException("Cannot set both row number and inventory type");
            }
            this.rows = rows;
            return this;
        }

        @NotNull
        public Builder setInventoryType(@Nullable InventoryType type) {
            this.type = type;
            if (this.rows != null) {
                throw new IllegalStateException("Cannot set both row number and inventory type");
            }
            return this;
        }

        @NotNull
        public Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        @NotNull
        public Builder setCloseBehavior(@NotNull CloseBehavior closeBehavior) {
            this.closeBehavior = closeBehavior;
            return this;
        }

        @NotNull
        public LayoutedGUI build() {
            if (this.type != null) {
                return new LayoutedTypeGUI(this.name, this.buttons, this.closeBehavior, this.type);
            }
            if (this.rows == null) {
                int maxSlot = this.buttons.keySet().stream().mapToInt(Integer::intValue).max().orElse(0);
                this.rows = (int)Math.floor((double)maxSlot / 9.0) + 1;
            }
            return new LayoutedRowsGUI(this.name, this.buttons, this.closeBehavior, this.rows);
        }
    }

    public static class LayoutedTypeGUI
    extends LayoutedGUI {
        @NotNull
        private final String name;
        @NotNull
        private final InventoryType type;

        protected LayoutedTypeGUI(@Nullable String name, @NotNull Map<Integer, LayoutedButton> buttons, @NotNull CloseBehavior closeBehavior, @NotNull InventoryType type) {
            super(buttons, closeBehavior);
            this.name = name;
            this.type = Objects.requireNonNull(type);
        }

        @Override
        protected final Inventory instanciate(@NotNull Player player) {
            return Bukkit.createInventory(null, (InventoryType)this.type, (String)this.name);
        }
    }

    public static class LayoutedRowsGUI
    extends LayoutedGUI {
        @NotNull
        private final String name;
        private final int rows;

        protected LayoutedRowsGUI(@NotNull String name, @NotNull Map<Integer, LayoutedButton> buttons, @NotNull CloseBehavior closeBehavior, int rows) {
            super(buttons, closeBehavior);
            this.name = name;
            Validate.isTrue((rows >= 1 ? 1 : 0) != 0);
            this.rows = rows;
        }

        @Override
        protected final Inventory instanciate(@NotNull Player player) {
            return Bukkit.createInventory(null, (int)(this.rows * 9), (String)this.name);
        }
    }
}

