/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.gui.templates;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import fr.skytasul.quests.api.localization.Lang;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.bukkit.DyeColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class ListGUI<T>
extends PagedGUI<T> {
    private ItemStack create = ItemUtils.item(XMaterial.SLIME_BALL, Lang.addObject.toString(), new String[0]);

    protected ListGUI(@NotNull String name, @NotNull DyeColor color, @NotNull Collection<T> objects) {
        super(name, color, objects);
        if (objects.contains(null)) {
            throw new IllegalArgumentException("Object cannot be null in a list GUI");
        }
        this.objects.add(null);
        this.validate = list -> {
            list.remove(null);
            this.finish((List<T>)list);
        };
    }

    @Override
    public final ItemStack getItemStack(T object) {
        return object == null ? this.create : this.getObjectItemStack(object);
    }

    @Override
    public final void click(T existing, ItemStack item, ClickType clickType) {
        if (existing != null && clickType == this.getRemoveClick(existing)) {
            this.remove(existing);
        } else if (existing == null) {
            this.createObject(this::finishItem);
        } else {
            this.clickObject(existing, item, clickType);
        }
    }

    protected ClickType getRemoveClick(@NotNull T object) {
        return ClickType.SHIFT_LEFT;
    }

    @NotNull
    protected LoreBuilder createLoreBuilder(@NotNull T object) {
        return new LoreBuilder().addClick(this.getRemoveClick(object), "\u00a7c" + Lang.Remove.toString());
    }

    public boolean remove(T object) {
        int index = this.objects.indexOf(object);
        if (index == -1) {
            return false;
        }
        this.remove(index);
        return true;
    }

    public void remove(int slot) {
        Object removed = this.objects.remove(slot);
        if (removed == null) {
            return;
        }
        this.calcMaxPages();
        this.page = this.maxPage - 1;
        this.setItems();
        this.removed(removed);
    }

    protected void removed(T object) {
    }

    public void updateObject(T object, T newObject) {
        int index = this.objects.indexOf(object);
        if (index == -1) {
            return;
        }
        this.objects.set(index, newObject);
        int slot = this.getObjectSlot(newObject);
        if (slot != -1) {
            this.getInventory().setItem(slot, this.getItemStack(newObject));
        }
    }

    @Override
    public CloseBehavior onClose(Player player) {
        return StandardCloseBehavior.REOPEN;
    }

    private ItemStack finishItem(T object) {
        Validate.notNull(object);
        this.objects.add(this.objects.size() - 1, object);
        this.calcMaxPages();
        this.page = this.maxPage - 1;
        this.setItems();
        this.reopen(this.player);
        int slot = this.getObjectSlot(object);
        return slot != -1 ? this.getInventory().getItem(slot) : this.getObjectItemStack(object);
    }

    public abstract void finish(List<T> var1);

    public abstract ItemStack getObjectItemStack(T var1);

    public abstract void createObject(Function<T, ItemStack> var1);

    public void clickObject(T object, ItemStack item, ClickType clickType) {
    }
}

