/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.gui.templates;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.gui.AbstractGui;
import fr.skytasul.quests.api.gui.GuiClickEvent;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.utils.LevenshteinComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PagedGUI<T>
extends AbstractGui {
    private static ItemStack itemSearch = ItemUtils.item(XMaterial.COMPASS, Lang.search.toString(), new String[0]);
    @Deprecated
    protected Player player;
    protected int page = 0;
    protected int maxPage;
    private final int columns;
    private final int dataSlots;
    private String name;
    private DyeColor color;
    protected List<T> objects;
    protected Consumer<List<T>> validate;
    private ItemStack validationItem = QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getDone();
    protected LevenshteinComparator<T> comparator;

    protected PagedGUI(@NotNull String name, @Nullable DyeColor color, @NotNull Collection<T> objects) {
        this(name, color, objects, null, null);
    }

    protected PagedGUI(@NotNull String name, @Nullable DyeColor color, @NotNull Collection<T> objects, @Nullable Consumer<List<T>> validate, @Nullable Function<T, String> searchName) {
        this.name = name;
        this.color = color;
        this.objects = new ArrayList<T>(objects);
        this.validate = validate;
        if (searchName != null) {
            this.comparator = new LevenshteinComparator<T>(searchName);
        }
        this.columns = QuestsConfiguration.getConfig().getGuiConfig().showVerticalSeparator() ? 7 : 8;
        this.dataSlots = this.columns * 5;
    }

    @Override
    protected Inventory instanciate(@NotNull Player player) {
        return Bukkit.createInventory(null, (int)45, (String)this.name);
    }

    @Override
    protected void populate(@NotNull Player player, @NotNull Inventory inventory) {
        this.player = player;
        this.calcMaxPages();
        this.setBarItem(0, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getPreviousPage());
        this.setBarItem(4, QuestsPlugin.getPlugin().getGuiManager().getItemFactory().getNextPage());
        if (this.validate != null) {
            this.setBarItem(2, this.validationItem);
        }
        if (this.comparator != null) {
            this.setBarItem(3, itemSearch);
        }
        this.displaySeparator();
        this.setItems();
    }

    private void displaySeparator() {
        if (this.color != null && QuestsConfiguration.getConfig().getGuiConfig().showVerticalSeparator()) {
            for (int i = 0; i < 5; ++i) {
                this.getInventory().setItem(i * 9 + this.columns, ItemUtils.itemSeparator(this.color));
            }
        }
    }

    @NotNull
    protected Player getViewer() {
        if (this.player == null) {
            throw new IllegalStateException("Inventory does not have a viewer");
        }
        return this.player;
    }

    public PagedGUI<T> setValidate(Consumer<List<T>> validate, ItemStack validationItem) {
        if (this.validate != null) {
            throw new IllegalStateException("A validation has already be added.");
        }
        if (this.getInventory() != null) {
            throw new IllegalStateException("Cannot add a validation after inventory opening.");
        }
        if (validationItem == null) {
            throw new IllegalArgumentException("Cannot set a null validation item.");
        }
        this.validate = validate;
        this.validationItem = validationItem;
        return this;
    }

    public PagedGUI<T> sortValuesByName() {
        Validate.notNull(this.comparator);
        this.sortValues(this.comparator.getFunction());
        return this;
    }

    public <C extends Comparable<C>> PagedGUI<T> sortValues(Function<T, C> mapper) {
        this.objects.sort((o1, o2) -> {
            Comparable map2;
            Comparable map1;
            if (o1 == null || (map1 = (Comparable)mapper.apply(o1)) == null) {
                return 1;
            }
            if (o2 == null || (map2 = (Comparable)mapper.apply(o2)) == null) {
                return -1;
            }
            return map1.compareTo(map2);
        });
        return this;
    }

    public void setSeparatorColor(@Nullable DyeColor color) {
        this.color = color;
        if (this.getInventory() != null) {
            this.displaySeparator();
        }
    }

    public void setObjects(@NotNull Collection<T> objects) {
        this.objects = new ArrayList<T>(objects);
        this.page = 0;
        this.calcMaxPages();
        this.setItems();
    }

    protected void calcMaxPages() {
        this.maxPage = this.objects.isEmpty() ? 1 : (int)Math.ceil((double)this.objects.size() * 1.0 / 35.0);
    }

    protected void setItems() {
        int i;
        for (i = 0; i < this.dataSlots; ++i) {
            this.setMainItem(i, null);
        }
        for (i = this.page * this.dataSlots; i < this.objects.size() && i != (this.page + 1) * this.dataSlots; ++i) {
            T obj = this.objects.get(i);
            this.setMainItem(i - this.page * this.dataSlots, this.getItemStack(obj));
        }
    }

    private int setMainItem(int mainSlot, ItemStack is) {
        int line = (int)Math.floor((double)mainSlot * 1.0 / (double)this.columns);
        int slot = mainSlot + (9 - this.columns) * line;
        this.setItem(is, slot);
        return slot;
    }

    protected int setBarItem(int barSlot, ItemStack is) {
        int slot = barSlot * 9 + 8;
        this.setItem(is, slot);
        return slot;
    }

    private void setItem(ItemStack is, int rawSlot) {
        ItemStack invItem;
        this.getInventory().setItem(rawSlot, is);
        if (is != null && is.getType() != Material.AIR && ((invItem = this.getInventory().getItem(rawSlot)) == null || invItem.getType() == Material.AIR)) {
            is = is.clone();
            is.setType(Material.STONE);
            this.getInventory().setItem(rawSlot, is);
        }
    }

    public int getObjectSlot(T object) {
        int index = this.objects.indexOf(object);
        if (index < this.page * this.dataSlots || index > (this.page + 1) * this.dataSlots) {
            return -1;
        }
        int line = (int)Math.floor((double)index * 1.0 / (double)this.columns);
        return index + (9 - this.columns) * line - this.page * this.dataSlots;
    }

    @Override
    public void onClick(GuiClickEvent event) {
        int column = event.getSlot() % 9;
        if (column == 8) {
            int barSlot = (event.getSlot() - 8) / 9;
            this.barClick(event, barSlot);
        } else if (!QuestsConfiguration.getConfig().getGuiConfig().showVerticalSeparator() || column != 7) {
            int line = (int)Math.floor((double)event.getSlot() * 1.0 / 9.0);
            int objectSlot = event.getSlot() - line * (9 - this.columns) + this.page * this.dataSlots;
            this.click(this.objects.get(objectSlot), event.getClicked(), event.getClick());
        }
    }

    protected void barClick(GuiClickEvent event, int barSlot) {
        switch (barSlot) {
            case 0: {
                if (this.page == 0) break;
                --this.page;
                this.setItems();
                break;
            }
            case 4: {
                if (this.page + 1 == this.maxPage) break;
                ++this.page;
                this.setItems();
                break;
            }
            case 2: {
                this.validate.accept(this.objects);
                break;
            }
            case 3: {
                new TextEditor<String>(this.player, this::reopen, obj -> {
                    this.objects.sort(this.comparator.setReference((String)obj));
                    this.page = 0;
                    this.setItems();
                    this.reopen();
                }).start();
            }
        }
    }

    public final void reopen() {
        this.reopen(this.player);
    }

    public final void close() {
        this.close(this.player);
    }

    @NotNull
    public abstract ItemStack getItemStack(@NotNull T var1);

    public abstract void click(@NotNull T var1, @NotNull ItemStack var2, @NotNull ClickType var3);
}

