/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.gui.templates;

import fr.skytasul.quests.api.gui.close.CloseBehavior;
import fr.skytasul.quests.api.gui.close.DelayCloseBehavior;
import fr.skytasul.quests.api.gui.close.StandardCloseBehavior;
import fr.skytasul.quests.api.gui.templates.PagedGUI;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.bukkit.DyeColor;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class StaticPagedGUI<T>
extends PagedGUI<Map.Entry<T, ItemStack>> {
    protected final Consumer<T> clicked;
    private boolean cancelAllowed = false;

    public StaticPagedGUI(String name, DyeColor color, Map<T, ItemStack> objects, Consumer<T> clicked, Function<T, String> nameMapper) {
        super(name, color, objects.entrySet(), null, nameMapper == null ? null : entry -> (String)nameMapper.apply(entry.getKey()));
        this.clicked = clicked;
    }

    public StaticPagedGUI<T> allowCancel() {
        this.cancelAllowed = true;
        return this;
    }

    @Override
    public ItemStack getItemStack(Map.Entry<T, ItemStack> object) {
        return object.getValue();
    }

    @Override
    public void click(Map.Entry<T, ItemStack> existing, ItemStack item, ClickType clickType) {
        this.clicked.accept(existing.getKey());
    }

    @Override
    public CloseBehavior onClose(Player player) {
        if (this.cancelAllowed) {
            return new DelayCloseBehavior(() -> this.clicked.accept(null));
        }
        return StandardCloseBehavior.REOPEN;
    }
}

