/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.localization;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.utils.ChatColorUtils;
import fr.skytasul.quests.api.utils.Utils;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.MessageType;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Objects;
import java.util.logging.Level;
import net.kyori.adventure.audience.Audience;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Locale {
    @NotNull
    public String getPath();

    @NotNull
    public String getValue();

    @NotNull
    public MessageType getType();

    public void setValue(@NotNull String var1);

    @NotNull
    default public String format(@Nullable HasPlaceholders placeholdersHolder) {
        return MessageUtils.format(this.getValue(), placeholdersHolder == null ? null : placeholdersHolder.getPlaceholdersRegistry());
    }

    @NotNull
    default public String format(HasPlaceholders ... placeholdersHolders) {
        return this.format((HasPlaceholders)PlaceholderRegistry.combine(placeholdersHolders));
    }

    @NotNull
    default public String quickFormat(@NotNull String key1, @Nullable Object value1) {
        String replacement = Objects.toString(value1);
        return this.getValue().replace("{0}", replacement).replace("{" + key1 + "}", replacement);
    }

    default public void send(@NotNull Audience audience) {
        this.send(audience, new HasPlaceholders[]{null});
    }

    default public void send(@NotNull CommandSender sender) {
        this.send(QuestsPlugin.getPlugin().getAudiences().sender(sender));
    }

    default public void send(@NotNull Audience audience, HasPlaceholders ... placeholdersHolders) {
        HasPlaceholders fullHolder = null;
        if (placeholdersHolders != null) {
            fullHolder = placeholdersHolders.length == 1 ? placeholdersHolders[0] : PlaceholderRegistry.combine(placeholdersHolders);
        }
        MessageUtils.sendMessage(audience, this.getValue(), this.getType(), fullHolder == null ? null : fullHolder.getPlaceholdersRegistry());
    }

    default public void send(@NotNull CommandSender sender, HasPlaceholders ... placeholdersHolders) {
        this.send(QuestsPlugin.getPlugin().getAudiences().sender(sender), placeholdersHolders);
    }

    default public void quickSend(@NotNull Audience audience, @NotNull String key1, @Nullable Object value1) {
        this.send(audience, PlaceholderRegistry.of(key1, value1));
    }

    default public void quickSend(@NotNull CommandSender sender, @NotNull String key1, @Nullable Object value1) {
        this.quickSend(QuestsPlugin.getPlugin().getAudiences().sender(sender), key1, value1);
    }

    public static void loadStrings(@NotNull @NotNull Locale @NotNull [] locales, @NotNull YamlConfiguration defaultConfig, @Nullable YamlConfiguration config) {
        ArrayList<String> missing = new ArrayList<String>();
        for (Locale l : locales) {
            String value = null;
            if (config != null) {
                value = config.getString(l.getPath(), null);
            }
            if (value == null) {
                value = defaultConfig.getString(l.getPath(), null);
                missing.add(l.getPath());
            }
            if (value == null) {
                QuestsPlugin.getPlugin().getLoggerExpanded().debug("Unavailable string in config for key " + l.getPath());
            }
            l.setValue(ChatColorUtils.translateHexColorCodes(ChatColor.translateAlternateColorCodes((char)'&', (String)(value == null ? "\u00a7cunknown string" : value))));
        }
        if (config != null && !missing.isEmpty()) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("The file is not fully translated! " + missing.size() + " missing translations.");
            QuestsPlugin.getPlugin().getLoggerExpanded().debug("Missing translations: " + String.join((CharSequence)", ", missing));
        }
    }

    public static YamlConfiguration loadLang(@NotNull Plugin plugin, @NotNull @NotNull Locale @NotNull [] locales, @NotNull String loadedLanguage) throws IOException, URISyntaxException {
        long lastMillis = System.currentTimeMillis();
        Utils.walkResources(plugin.getClass(), "/locales", 1, path -> {
            String localeFileName = path.getFileName().toString();
            if (!localeFileName.toLowerCase().endsWith(".yml")) {
                return;
            }
            if (!Files.exists(plugin.getDataFolder().toPath().resolve("locales").resolve(localeFileName), new LinkOption[0])) {
                plugin.saveResource("locales/" + localeFileName, false);
            }
        });
        String language = "locales/" + loadedLanguage + ".yml";
        File file = new File(plugin.getDataFolder(), language);
        InputStream res = plugin.getResource(language);
        boolean created = false;
        if (!file.exists()) {
            plugin.getLogger().warning("Language file " + language + " does not exist. Using default english strings.");
            file.createNewFile();
            res = plugin.getResource("locales/en_US.yml");
            created = true;
        }
        YamlConfiguration def = null;
        if (res != null) {
            def = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(res, StandardCharsets.UTF_8));
        }
        YamlConfiguration conf = new YamlConfiguration();
        try {
            conf.load(file);
            boolean changes = false;
            if (def != null) {
                for (String key : def.getKeys(true)) {
                    if (def.isConfigurationSection(key) || conf.contains(key)) continue;
                    conf.set(key, def.get(key));
                    if (!created) {
                        QuestsPlugin.getPlugin().getLoggerExpanded().debug("String copied from source file to " + language + ". Key: " + key);
                    }
                    changes = true;
                }
            }
            if (changes) {
                plugin.getLogger().info("Copied new strings into " + language + " language file.");
                conf.save(file);
            }
        }
        catch (Exception ex) {
            conf = def;
            plugin.getLogger().log(Level.SEVERE, "Failed to load language file " + String.valueOf(file), ex);
        }
        Locale.loadStrings(locales, YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(plugin.getResource("locales/en_US.yml"), StandardCharsets.UTF_8)), conf);
        plugin.getLogger().info("Loaded language " + loadedLanguage + " (" + ((double)System.currentTimeMillis() - (double)lastMillis) / 1000.0 + "s)!");
        return conf;
    }
}

