/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.mobs;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.events.internal.BQMobDeathEvent;
import fr.skytasul.quests.api.utils.AutoRegistered;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoRegistered
public interface MobFactory<T> {
    public static final Cache<Event, BQMobDeathEvent> eventsCache = CacheBuilder.newBuilder().expireAfterWrite(2L, TimeUnit.SECONDS).build();
    public static final List<MobFactory<?>> factories = new ArrayList();

    @NotNull
    public String getID();

    @NotNull
    public ItemStack getFactoryItem();

    public void itemClick(@NotNull Player var1, @NotNull Consumer<@Nullable T> var2);

    @NotNull
    public T fromValue(@NotNull String var1);

    @NotNull
    public String getValue(@NotNull T var1);

    @NotNull
    public String getName(@NotNull T var1);

    @NotNull
    public EntityType getEntityType(@NotNull T var1);

    default public @NotNull List<@Nullable String> getDescriptiveLore(@NotNull T data) {
        return Collections.emptyList();
    }

    default public boolean mobApplies(@Nullable T first, @Nullable Object other) {
        return Objects.equals(first, other);
    }

    public boolean bukkitMobApplies(@NotNull T var1, @NotNull Entity var2);

    default public void callEvent(@Nullable Event originalEvent, @NotNull T pluginMob, @Nullable Entity entity, @NotNull Entity killer) {
        BQMobDeathEvent existingCompat;
        Validate.notNull(pluginMob, (String)"Plugin mob object cannot be null");
        Validate.notNull((Object)killer, (String)"Killer cannot be null");
        if (originalEvent != null && (existingCompat = (BQMobDeathEvent)((Object)eventsCache.getIfPresent((Object)originalEvent))) != null && this.mobApplies(pluginMob, existingCompat.getPluginMob())) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("MobFactory.callEvent() called twice!");
            return;
        }
        OptionalInt optionalStackSize = QuestsAPI.getAPI().getMobStackers().stream().mapToInt(stacker -> stacker.getEntityStackSize(entity)).filter(size -> size > 1).max();
        BQMobDeathEvent compatEvent = new BQMobDeathEvent(pluginMob, killer, entity, optionalStackSize.orElse(1));
        if (originalEvent != null) {
            eventsCache.put((Object)originalEvent, (Object)compatEvent);
        }
        Bukkit.getPluginManager().callEvent((Event)compatEvent);
    }

    @Nullable
    public static MobFactory<?> getMobFactory(@NotNull String id) {
        for (MobFactory<?> factory : factories) {
            if (!factory.getID().equals(id)) continue;
            return factory;
        }
        return null;
    }
}

