/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.npcs.dialogs;

import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.npcs.dialogs.Message;
import fr.skytasul.quests.api.utils.NumberedList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Dialog
implements Cloneable {
    @NotNull
    private List<Message> messages;
    @Nullable
    private String npcName = null;
    @Nullable
    private Boolean skippable = null;

    public Dialog() {
        this(new ArrayList<Message>());
    }

    public Dialog(@NotNull List<Message> messages) {
        this.messages = messages;
    }

    @NotNull
    public List<Message> getMessages() {
        return this.messages;
    }

    public void setMessages(@NotNull List<Message> messages) {
        this.messages = messages;
    }

    @NotNull
    public String getNPCName(@Nullable BqNpc defaultNPC) {
        if (this.npcName != null) {
            return this.npcName;
        }
        if (defaultNPC == null) {
            return Lang.Unknown.toString();
        }
        return defaultNPC.getNpc().getName();
    }

    @Nullable
    public String getNpcName() {
        return this.npcName;
    }

    public void setNpcName(@Nullable String npcName) {
        this.npcName = npcName;
    }

    public void add(String msg, Message.Sender sender) {
        this.messages.add(new Message(msg, sender));
    }

    public void insert(String msg, Message.Sender sender, int id) {
        this.messages.add(id, new Message(msg, sender));
    }

    public boolean isSkippable() {
        return this.skippable == null ? QuestsConfiguration.getConfig().getDialogsConfig().isSkippableByDefault() : this.skippable.booleanValue();
    }

    public void setSkippable(@Nullable Boolean skippable) {
        this.skippable = skippable;
    }

    public String getSkippableStatus() {
        Object msg;
        Object object = msg = this.isSkippable() ? Lang.Enabled.toString() : Lang.Disabled.toString();
        if (this.skippable == null) {
            msg = (String)msg + " " + Lang.defaultValue.toString();
        }
        return msg;
    }

    public Dialog clone() {
        Dialog clone = new Dialog();
        for (Message msg : this.messages) {
            clone.messages.add(msg.clone());
        }
        clone.npcName = this.npcName;
        return clone;
    }

    public void serialize(ConfigurationSection section) {
        ArrayList ls = new ArrayList();
        for (int i = 0; i < this.messages.size(); ++i) {
            HashMap<String, Object> msgm = new HashMap<String, Object>();
            msgm.put("id", i);
            msgm.put("message", this.messages.get(i).serialize());
            ls.add(msgm);
        }
        section.set("msgs", ls);
        if (this.npcName != null) {
            section.set("npcName", (Object)this.npcName);
        }
        if (this.skippable != null) {
            section.set("skippable", (Object)this.skippable);
        }
    }

    public static Dialog deserialize(ConfigurationSection section) {
        NumberedList<Message> tmpMessages = new NumberedList<Message>();
        for (Map msg : section.getMapList("msgs")) {
            int id = (Integer)msg.get("id");
            tmpMessages.set(id, Message.deserialize((Map)msg.get("message")));
        }
        Dialog di = new Dialog(tmpMessages.toList());
        if (section.contains("npcName")) {
            di.npcName = section.getString("npcName");
        }
        if (section.contains("skippable")) {
            di.skippable = section.getBoolean("skippable");
        }
        return di;
    }
}

