/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.npcs.dialogs;

import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.npcs.dialogs.Dialog;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DialogRunner {
    @Nullable
    public BqNpc getNpc();

    @Nullable
    public Dialog getDialog();

    public void addTest(Predicate<Player> var1);

    public void addTestCancelling(Predicate<Player> var1);

    public void addEndAction(Consumer<Player> var1);

    public boolean canContinue(Player var1);

    public TestResult onClick(Player var1);

    public TestResult handleNext(Player var1, DialogNextReason var2);

    public boolean isPlayerInDialog(Player var1);

    public int getPlayerMessage(Player var1);

    public boolean removePlayer(Player var1);

    public void forceFinish(@NotNull Player var1);

    public static enum TestResult {
        ALLOW,
        DENY,
        DENY_CANCEL;


        public TestResult accumulate(TestResult other) {
            if (this == DENY_CANCEL || other == DENY_CANCEL) {
                return DENY_CANCEL;
            }
            if (this == DENY || other == DENY) {
                return DENY;
            }
            return ALLOW;
        }

        public boolean shouldCancel() {
            return this == DENY_CANCEL || this == ALLOW;
        }
    }

    public static enum DialogNextReason {
        NPC_CLICK,
        AUTO_TIME,
        COMMAND,
        PLUGIN;

    }
}

