/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.npcs.dialogs;

import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.messaging.PlaceholdersContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Message
implements Cloneable {
    public String text;
    public Sender sender;
    public String sound;
    public int wait = -1;

    public Message(String msg, Sender sender) {
        this.text = msg;
        this.sender = sender;
    }

    public int getWaitTime() {
        return this.wait == -1 ? QuestsConfiguration.getConfig().getDialogsConfig().getDefaultTime() : this.wait;
    }

    public void playSound(@NotNull Player player, @Nullable Entity speaker) {
        this.getSound().ifPresent(sound -> {
            Location location = speaker == null ? player.getLocation() : speaker.getLocation();
            player.playSound(location, sound, 1.0f, 1.0f);
        });
    }

    public void stopSound(@NotNull Player player) {
        this.getSound().ifPresent(arg_0 -> ((Player)player).stopSound(arg_0));
    }

    @NotNull
    private Optional<String> getSound() {
        String sentSound = this.sound;
        if (sentSound == null) {
            if (this.sender == Sender.PLAYER) {
                sentSound = QuestsConfiguration.getConfig().getDialogsConfig().getDefaultPlayerSound();
            } else if (this.sender == Sender.NPC) {
                sentSound = QuestsConfiguration.getConfig().getDialogsConfig().getDefaultNPCSound();
            }
        }
        if ("none".equals(sentSound)) {
            return Optional.empty();
        }
        return Optional.ofNullable(sentSound);
    }

    @NotNull
    public String formatMessage(@NotNull Player p, @Nullable BqNpc npc, @Nullable String npcCustomName, int id, int size) {
        PlaceholderRegistry registry = new PlaceholderRegistry().registerIndexed("player_name", p.getName()).registerIndexed("npc_name_message", npcCustomName).registerIndexed("message_id", id + 1).registerIndexed("message_count", size);
        if (npc != null) {
            registry.compose(npc);
        }
        String sent = MessageUtils.finalFormat(this.text, registry.withoutIndexes("npc_name_message", "player_name"), PlaceholdersContext.of(p, true, null));
        registry.registerIndexed("text", sent);
        switch (this.sender.ordinal()) {
            case 0: {
                sent = MessageUtils.finalFormat(Lang.SelfText.toString(), registry.withoutIndexes("npc_name_message"), PlaceholdersContext.of(p, true, null));
                break;
            }
            case 1: {
                sent = MessageUtils.finalFormat(Lang.NpcText.toString(), registry.withoutIndexes("player_name"), PlaceholdersContext.of(p, true, null));
                break;
            }
        }
        return sent;
    }

    public Message clone() {
        Message clone = new Message(this.text, this.sender);
        clone.sound = this.sound;
        clone.wait = this.wait;
        return clone;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("text", this.text);
        map.put("sender", this.sender.name());
        if (this.sound != null) {
            map.put("sound", this.sound);
        }
        if (this.wait != -1) {
            map.put("wait", this.wait);
        }
        return map;
    }

    public static Message deserialize(Map<String, Object> map) {
        Message msg = new Message((String)map.get("text"), Sender.fromString((String)map.get("sender")));
        if (map.containsKey("sound")) {
            msg.sound = (String)map.get("sound");
        }
        if (map.containsKey("wait")) {
            msg.wait = (Integer)map.get("wait");
        }
        return msg;
    }

    public static enum Sender {
        PLAYER,
        NPC,
        NOSENDER;


        public static Sender fromString(String string) {
            if (string.equalsIgnoreCase("NOTHING")) {
                return NOSENDER;
            }
            return Sender.valueOf(string.toUpperCase());
        }
    }
}

