/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.objects;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.objects.QuestObjectCreator;
import fr.skytasul.quests.api.objects.QuestObjectsRegistry;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.serializable.SerializableObject;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QuestObject
extends SerializableObject
implements Cloneable,
HasPlaceholders {
    protected static final String CUSTOM_DESCRIPTION_KEY = "customDescription";
    private Quest quest;
    private String customDescription;
    @Nullable
    private PlaceholderRegistry placeholders;

    protected QuestObject(@NotNull QuestObjectsRegistry registry, @Nullable String customDescription) {
        super(registry);
        this.customDescription = customDescription;
    }

    @Override
    public QuestObjectCreator getCreator() {
        return (QuestObjectCreator)super.getCreator();
    }

    public void attach(@NotNull Quest quest) {
        this.quest = quest;
    }

    public void detach() {
        this.quest = null;
    }

    @Nullable
    public Quest getAttachedQuest() {
        return this.quest;
    }

    @Nullable
    public String getCustomDescription() {
        return this.customDescription;
    }

    public void setCustomDescription(@Nullable String customDescription) {
        this.customDescription = customDescription;
    }

    @NotNull
    public String debugName() {
        return this.getClass().getSimpleName() + (String)(this.quest == null ? ", unknown quest" : ", quest " + this.quest.getId());
    }

    public boolean isValid() {
        return true;
    }

    @NotNull
    protected String getInvalidReason() {
        return "invalid";
    }

    @Override
    @NotNull
    public final PlaceholderRegistry getPlaceholdersRegistry() {
        if (this.placeholders == null) {
            this.placeholders = new PlaceholderRegistry();
            this.createdPlaceholdersRegistry(this.placeholders);
        }
        return this.placeholders;
    }

    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        placeholders.register("custom_description", () -> this.customDescription);
        placeholders.register("object_type", this.creator.getID());
    }

    @Override
    @NotNull
    public abstract QuestObject clone();

    @Override
    public void save(@NotNull ConfigurationSection section) {
        if (this.customDescription != null) {
            section.set(CUSTOM_DESCRIPTION_KEY, (Object)this.customDescription);
        }
    }

    @Override
    public void load(@NotNull ConfigurationSection section) {
        if (section.contains(CUSTOM_DESCRIPTION_KEY)) {
            this.customDescription = section.getString(CUSTOM_DESCRIPTION_KEY);
        }
    }

    @Nullable
    public final String getDescription(@Nullable Player player) {
        String string;
        String string2 = string = this.customDescription == null ? this.getDefaultDescription(player) : this.customDescription;
        if (string != null) {
            string = MessageUtils.format(string, this.getPlaceholdersRegistry());
        }
        return string;
    }

    @Nullable
    protected String getDefaultDescription(@Nullable Player p) {
        return null;
    }

    public @NotNull String @Nullable [] getItemLore() {
        LoreBuilder lore = new LoreBuilder();
        this.addLore(lore);
        return lore.toLoreArray();
    }

    protected void addLore(@NotNull LoreBuilder loreBuilder) {
        String description;
        loreBuilder.addClick(this.getRemoveClick(), "\u00a7c" + Lang.Remove.toString());
        loreBuilder.addClick(this.getCustomDescriptionClick(), Lang.object_description_set.toString());
        try {
            description = this.getDescription(null);
        }
        catch (Exception ex) {
            description = "\u00a7cerror";
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Could not get quest object description during edition", ex);
        }
        if (description != null) {
            loreBuilder.addDescription(Lang.object_description.format((HasPlaceholders)PlaceholderRegistry.of("description", description + (String)(this.customDescription == null ? " " + String.valueOf(Lang.defaultValue) : ""))));
        }
    }

    @NotNull
    public ItemStack getItemStack() {
        return ItemUtils.lore(this.getCreator().getItem().clone(), this.getItemLore());
    }

    @Nullable
    public ClickType getRemoveClick() {
        return ClickType.SHIFT_LEFT;
    }

    @Nullable
    protected ClickType getCustomDescriptionClick() {
        return ClickType.RIGHT;
    }

    protected abstract void sendCustomDescriptionHelpMessage(@NotNull Player var1);

    public final void click(@NotNull QuestObjectClickEvent event) {
        if (event.getClick() == this.getRemoveClick()) {
            return;
        }
        if (event.getClick() == this.getCustomDescriptionClick()) {
            this.sendCustomDescriptionHelpMessage(event.getPlayer());
            new TextEditor<String>(event.getPlayer(), event::reopenGUI, msg -> {
                this.setCustomDescription((String)msg);
                event.reopenGUI();
            }).passNullIntoEndConsumer().start();
        } else {
            this.clickInternal(event);
        }
    }

    protected abstract void clickInternal(@NotNull QuestObjectClickEvent var1);
}

