/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.objects;

import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.objects.QuestObject;
import fr.skytasul.quests.api.objects.QuestObjectGUI;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class QuestObjectClickEvent {
    @NotNull
    private final Player player;
    @NotNull
    private final QuestObjectGUI gui;
    @NotNull
    private final ItemStack item;
    @NotNull
    private final ClickType click;
    @NotNull
    private final QuestObject clickedObject;
    private final boolean creation;

    public QuestObjectClickEvent(@NotNull Player player, @NotNull QuestObjectGUI gui, @NotNull ItemStack item, @NotNull ClickType click, boolean creation, @NotNull QuestObject clickedObject) {
        this.player = player;
        this.gui = gui;
        this.item = item;
        this.click = click;
        this.creation = creation;
        this.clickedObject = clickedObject;
    }

    @NotNull
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public QuestObjectGUI getGUI() {
        return this.gui;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    @NotNull
    public ClickType getClick() {
        return this.click;
    }

    public boolean isInCreation() {
        return this.creation;
    }

    public void reopenGUI() {
        this.updateItemLore();
        this.gui.reopen();
    }

    public void cancel() {
        if (this.creation) {
            this.gui.remove(this.clickedObject);
        }
        this.gui.reopen();
    }

    public void remove() {
        this.gui.remove(this.clickedObject);
        this.gui.reopen();
    }

    @Deprecated
    public void updateItemLore(String ... lore) {
        ItemUtils.lore(this.item, lore);
    }

    public void updateItemLore() {
        ItemUtils.lore(this.item, this.clickedObject.getItemLore());
    }
}

