/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.objects;

import fr.skytasul.quests.api.objects.QuestObject;
import fr.skytasul.quests.api.objects.QuestObjectLocation;
import fr.skytasul.quests.api.serializable.SerializableCreator;
import java.util.function.Supplier;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class QuestObjectCreator<T extends QuestObject>
extends SerializableCreator<T> {
    @NotNull
    private final ItemStack item;
    private final boolean multiple;
    @NotNull
    private @NotNull QuestObjectLocation @NotNull [] allowedLocations;

    public QuestObjectCreator(@NotNull String id, @NotNull Class<? extends T> clazz, @NotNull ItemStack item, @NotNull @NotNull Supplier<@NotNull T> newObjectSupplier) {
        this(id, clazz, item, newObjectSupplier, true, new QuestObjectLocation[0]);
    }

    public QuestObjectCreator(@NotNull String id, @NotNull Class<? extends T> clazz, @NotNull ItemStack item, @NotNull @NotNull Supplier<@NotNull T> newObjectSupplier, boolean multiple, QuestObjectLocation ... allowedLocations) {
        super(id, clazz, newObjectSupplier);
        this.item = item;
        this.multiple = multiple;
        this.allowedLocations = allowedLocations;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    public boolean canBeMultiple() {
        return this.multiple;
    }

    public boolean isAllowed(@NotNull QuestObjectLocation location) {
        if (this.allowedLocations.length == 0) {
            return true;
        }
        for (QuestObjectLocation allowed : this.allowedLocations) {
            if (allowed != location) continue;
            return true;
        }
        return false;
    }
}

