/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.objects;

import fr.skytasul.quests.api.objects.QuestObject;
import fr.skytasul.quests.api.objects.QuestObjectCreator;
import fr.skytasul.quests.api.objects.QuestObjectGUI;
import fr.skytasul.quests.api.objects.QuestObjectLocation;
import fr.skytasul.quests.api.serializable.SerializableRegistry;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestObjectsRegistry<T extends QuestObject, C extends QuestObjectCreator<T>>
extends SerializableRegistry<T, C> {
    @NotNull
    private final String inventoryName;

    public QuestObjectsRegistry(@NotNull String id, @NotNull String inventoryName) {
        super(id);
        this.inventoryName = inventoryName;
    }

    @NotNull
    public String getInventoryName() {
        return this.inventoryName;
    }

    public QuestObjectGUI<T> createGUI(@NotNull QuestObjectLocation location, @NotNull @NotNull Consumer<@NotNull List<T>> end, @NotNull List<T> objects) {
        return this.createGUI(this.inventoryName, location, end, objects, null);
    }

    public QuestObjectGUI<T> createGUI(@NotNull QuestObjectLocation location, @NotNull @NotNull Consumer<@NotNull List<T>> end, @NotNull List<T> objects, @Nullable Predicate<C> filter) {
        return this.createGUI(this.inventoryName, location, end, objects, filter);
    }

    public QuestObjectGUI<T> createGUI(@NotNull String name, @NotNull QuestObjectLocation location, @NotNull @NotNull Consumer<@NotNull List<T>> end, @NotNull List<T> objects) {
        return this.createGUI(name, location, end, objects, null);
    }

    public QuestObjectGUI<T> createGUI(@NotNull String name, @NotNull QuestObjectLocation location, @NotNull @NotNull Consumer<@NotNull List<T>> end, @NotNull @NotNull List<@NotNull T> objects, @Nullable Predicate<C> filter) {
        return new QuestObjectGUI<T>(name, location, filter == null ? this.creators : this.creators.stream().filter(filter).collect(Collectors.toList()), end, objects);
    }
}

