/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.options;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOptionCreator;
import fr.skytasul.quests.api.options.description.QuestDescriptionProvider;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.quests.creation.QuestCreationGuiClickEvent;
import fr.skytasul.quests.api.utils.AutoRegistered;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoRegistered
public abstract class QuestOption<T>
implements Cloneable {
    @NotNull
    private final QuestOptionCreator<T, QuestOption<T>> creator;
    @Nullable
    private T value;
    @Nullable
    private Quest attachedQuest;
    @NotNull
    private final @NotNull Class<? extends QuestOption<?>> @NotNull [] requiredQuestOptions;
    @Nullable
    private Runnable valueUpdateListener;

    protected QuestOption(Class<? extends QuestOption<?>> ... requiredQuestOptions) {
        this.requiredQuestOptions = requiredQuestOptions;
        Optional creatorOpt = QuestsAPI.getAPI().getQuestOption(this.getClass());
        this.creator = creatorOpt.orElseThrow(() -> new IllegalArgumentException(this.getClass().getName() + " has not been registered as a quest option via the API."));
        this.setValue(this.creator.defaultValue == null ? null : (T)this.cloneValue(this.creator.defaultValue));
    }

    @NotNull
    public QuestOptionCreator<T, QuestOption<T>> getOptionCreator() {
        return this.creator;
    }

    public final boolean hasCustomValue() {
        return !Objects.equals(this.value, this.creator.defaultValue);
    }

    @Nullable
    public final T getValue() {
        return this.value;
    }

    public void setValue(@Nullable T value) {
        this.value = value;
        this.valueUpdated();
    }

    public void resetValue() {
        this.setValue(this.creator.defaultValue);
    }

    protected void valueUpdated() {
        if (this.valueUpdateListener != null) {
            this.valueUpdateListener.run();
        }
    }

    public void setValueUpdaterListener(@Nullable Runnable listener) {
        this.valueUpdateListener = listener;
    }

    @NotNull
    public @NotNull Class<? extends QuestOption<?>> @NotNull [] getRequiredQuestOptions() {
        return this.requiredQuestOptions;
    }

    @Nullable
    public Quest getAttachedQuest() {
        return this.attachedQuest;
    }

    public void attach(@NotNull Quest quest) {
        Validate.notNull((Object)quest, (String)"Attached quest cannot be null");
        if (this.attachedQuest != null) {
            throw new IllegalStateException("This option is already attached to " + this.attachedQuest.getId());
        }
        this.attachedQuest = quest;
        if (this instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)QuestsPlugin.getPlugin());
        }
        if (this instanceof QuestDescriptionProvider) {
            quest.getDescriptions().add((QuestDescriptionProvider)((Object)this));
        }
    }

    public void detach() {
        Quest previous = this.attachedQuest;
        this.attachedQuest = null;
        if (this instanceof Listener) {
            HandlerList.unregisterAll((Listener)((Listener)this));
        }
        if (previous != null && this instanceof QuestDescriptionProvider) {
            previous.getDescriptions().remove(this);
        }
    }

    @Nullable
    public abstract Object save();

    public abstract void load(@NotNull ConfigurationSection var1, @NotNull String var2);

    @Nullable
    public abstract T cloneValue(@Nullable T var1);

    @NotNull
    public QuestOption<T> clone() {
        QuestOption clone = (QuestOption)this.creator.optionSupplier.get();
        clone.setValue(this.value == null ? null : (T)this.cloneValue(this.value));
        return clone;
    }

    public boolean shouldDisplay(@NotNull OptionSet options) {
        return true;
    }

    public void onDependenciesUpdated(@NotNull OptionSet options) {
    }

    @NotNull
    public abstract ItemStack getItemStack(@NotNull OptionSet var1);

    public abstract void click(@NotNull QuestCreationGuiClickEvent var1);

    @NotNull
    public String formatValue(@Nullable String valueString) {
        return QuestOption.formatNullableValue((Object)valueString, !this.hasCustomValue());
    }

    @Nullable
    public static String formatDescription(@Nullable String description) {
        return description == null ? null : "\u00a78> \u00a77" + description;
    }

    @NotNull
    public static String formatNullableValue(@Nullable Object value) {
        return QuestOption.formatNullableValue(value, false);
    }

    @NotNull
    public static String formatNullableValue(@Nullable Object value, @NotNull Object defaultValue) {
        return QuestOption.formatNullableValue(value == null ? defaultValue : value, value == null);
    }

    @NotNull
    public static String formatNullableValue(@Nullable Object value, boolean isDefault) {
        Object valueString = Lang.optionValue.format((HasPlaceholders)PlaceholderRegistry.of("value", value == null ? Lang.NotSet.toString() : value));
        if (isDefault) {
            valueString = (String)valueString + " " + Lang.defaultValue.toString();
        }
        return valueString;
    }
}

