/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.options;

import fr.skytasul.quests.api.options.QuestOption;
import java.util.Arrays;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestOptionCreator<D, T extends QuestOption<D>> {
    public final String id;
    public final int preferedSlot;
    public final Class<T> optionClass;
    public final Supplier<T> optionSupplier;
    public final String[] oldNames;
    public final D defaultValue;

    public QuestOptionCreator(@NotNull String id, int preferedSlot, @NotNull Class<T> optionClass, @NotNull @NotNull Supplier<@NotNull T> optionSupplier, @Nullable D defaultValue, String ... oldNames) {
        this.id = id;
        this.preferedSlot = preferedSlot;
        this.optionClass = optionClass;
        this.optionSupplier = optionSupplier;
        this.oldNames = oldNames;
        this.defaultValue = defaultValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean applies(@NotNull String key) {
        if (this.id.equals(key)) return true;
        if (!Arrays.stream(this.oldNames).anyMatch(key::equals)) return false;
        return true;
    }
}

