/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.options;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.quests.creation.QuestCreationGuiClickEvent;
import fr.skytasul.quests.api.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public abstract class QuestOptionItem
extends QuestOption<ItemStack> {
    public QuestOptionItem(Class<? extends QuestOption<?>> ... requiredQuestOptions) {
        super(requiredQuestOptions);
    }

    @Override
    public Object save() {
        return ((ItemStack)this.getValue()).serialize();
    }

    @Override
    public void load(ConfigurationSection config, String key) {
        this.setValue(ItemStack.deserialize(Utils.mapFromConfigurationSection(config.getConfigurationSection(key))));
    }

    @Override
    public ItemStack cloneValue(ItemStack value) {
        return value.clone();
    }

    private List<String> getLore() {
        ArrayList<String> lore = new ArrayList<String>();
        if (this.getItemDescription() != null) {
            lore.add(QuestOptionItem.formatDescription(this.getItemDescription()));
        }
        if (this.getValue() == null) {
            lore.add(Lang.NotSet.toString() + (String)(this.hasCustomValue() ? "" : " " + Lang.defaultValue.toString()));
        } else {
            lore.add("");
            lore.add("\u00a77Item name: \u00a7f" + ItemUtils.getName((ItemStack)this.getValue()));
            String[] itemLore = ItemUtils.getLore((ItemStack)this.getValue());
            if (itemLore != null) {
                lore.add("");
                lore.add("\u00a77Item lore:");
                lore.addAll(Arrays.asList(itemLore));
            }
            if (!this.hasCustomValue()) {
                lore.add("");
                lore.add(Lang.defaultValue.toString());
            }
            lore.add("");
            lore.add("\u00a78" + Lang.ClickShiftRight.toString() + " > \u00a77" + Lang.Remove.toString());
        }
        return lore;
    }

    @Override
    public ItemStack getItemStack(OptionSet options) {
        if (this.getValue() == null) {
            return ItemUtils.item(this.getDefaultMaterial(), this.getItemName(), this.getLore());
        }
        ItemStack item = ((ItemStack)this.getValue()).clone();
        ItemUtils.name(item, this.getItemName());
        ItemUtils.lore(item, this.getLore());
        return item;
    }

    @Override
    public void click(QuestCreationGuiClickEvent event) {
        if (event.getClick() == ClickType.SHIFT_RIGHT) {
            this.setValue(null);
            event.getGui().updateOptionItem(this);
        } else {
            QuestsPlugin.getPlugin().getGuiManager().getFactory().createItemSelection(is -> {
                this.setValue(is);
                event.getGui().updateOptionItem(this);
                event.reopen();
            }, event::reopen).open(event.getPlayer());
        }
    }

    public abstract XMaterial getDefaultMaterial();

    public abstract String getItemName();

    public String getItemDescription() {
        return null;
    }
}

