/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.options;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.objects.QuestObject;
import fr.skytasul.quests.api.objects.QuestObjectCreator;
import fr.skytasul.quests.api.objects.QuestObjectLocation;
import fr.skytasul.quests.api.objects.QuestObjectsRegistry;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.quests.creation.QuestCreationGuiClickEvent;
import fr.skytasul.quests.api.serializable.SerializableObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public abstract class QuestOptionObject<T extends QuestObject, C extends QuestObjectCreator<T>, L extends List<T>>
extends QuestOption<L> {
    public QuestOptionObject() {
        super(new Class[0]);
    }

    @Override
    public void attach(Quest quest) {
        super.attach(quest);
        this.attachObjects();
    }

    @Override
    public void detach() {
        super.detach();
        this.detachObjects();
    }

    @Override
    public void setValue(L value) {
        if (this.getValue() != null && this.getAttachedQuest() != null) {
            this.detachObjects();
        }
        super.setValue(value);
        if (this.getValue() != null && this.getAttachedQuest() != null) {
            this.attachObjects();
        }
    }

    private void detachObjects() {
        ((List)this.getValue()).forEach(QuestObject::detach);
    }

    private void attachObjects() {
        ((List)this.getValue()).forEach(this::attachObject);
    }

    protected void attachObject(T object) {
        ((QuestObject)object).attach(this.getAttachedQuest());
    }

    @Override
    public Object save() {
        return SerializableObject.serializeList((List)this.getValue());
    }

    @Override
    public void load(ConfigurationSection config, String key) {
        this.setValue(this.instanciate(SerializableObject.deserializeList(config.getMapList(key), this::deserialize)));
    }

    protected abstract T deserialize(Map<String, Object> var1);

    protected abstract String getSizeString();

    protected abstract QuestObjectsRegistry<T, C> getObjectsRegistry();

    protected abstract L instanciate(Collection<T> var1);

    @Override
    @Nullable
    public L cloneValue(@Nullable L value) {
        return this.instanciate((Collection<T>)value);
    }

    protected String[] getLore() {
        String count = "\u00a77" + this.getSizeString();
        if (this.getItemDescription() == null) {
            return new String[]{count};
        }
        return new String[]{QuestOptionObject.formatDescription(this.getItemDescription()), "", count};
    }

    @Override
    public ItemStack getItemStack(OptionSet options) {
        return ItemUtils.item(this.getItemMaterial(), this.getItemName(), this.getLore());
    }

    @Override
    public void click(QuestCreationGuiClickEvent event) {
        this.getObjectsRegistry().createGUI(QuestObjectLocation.QUEST, objects -> {
            this.setValue(this.instanciate((Collection<T>)objects));
            ItemUtils.lore(event.getClicked(), this.getLore());
            event.reopen();
        }, (List)this.getValue()).open(event.getPlayer());
    }

    public abstract XMaterial getItemMaterial();

    public abstract String getItemName();

    public String getItemDescription() {
        return null;
    }
}

