/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.options;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.TextListEditor;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.quests.creation.QuestCreationGuiClickEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public abstract class QuestOptionString
extends QuestOption<String> {
    public QuestOptionString(Class<? extends QuestOption<?>> ... requiredQuestOptions) {
        super(requiredQuestOptions);
    }

    @Override
    public Object save() {
        return this.getValue();
    }

    @Override
    public void load(ConfigurationSection config, String key) {
        this.setValue(config.getString(key));
    }

    @Override
    public String cloneValue(String value) {
        return value;
    }

    private String[] getLore() {
        if (this.getItemDescription() == null) {
            return new String[]{this.formatValue((String)this.getValue())};
        }
        String description = QuestOptionString.formatDescription(this.getItemDescription());
        return new String[]{description, "", this.formatValue((this.isMultiline() && this.getValue() != null ? "{nl}" : "") + (String)this.getValue())};
    }

    @Override
    public ItemStack getItemStack(OptionSet options) {
        return ItemUtils.item(this.getItemMaterial(), this.getItemName(), this.getLore());
    }

    @Override
    public void click(QuestCreationGuiClickEvent event) {
        this.sendIndication(event.getPlayer());
        if (this.isMultiline()) {
            ArrayList<String> splitText = this.getValue() == null || ((String)this.getValue()).isEmpty() ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(((String)this.getValue()).split("\\{nl\\}")));
            new TextListEditor(event.getPlayer(), list -> {
                this.setValue(list.stream().collect(Collectors.joining("{nl}")));
                ItemUtils.lore(event.getClicked(), this.getLore());
                event.reopen();
            }, splitText).start();
        } else {
            new TextEditor<String>(event.getPlayer(), event::reopen, obj -> {
                if (obj == null) {
                    this.resetValue();
                } else {
                    this.setValue(obj);
                }
                ItemUtils.lore(event.getClicked(), this.getLore());
                event.reopen();
            }).passNullIntoEndConsumer().start();
        }
    }

    public abstract void sendIndication(Player var1);

    public abstract XMaterial getItemMaterial();

    public abstract String getItemName();

    public String getItemDescription() {
        return null;
    }

    public boolean isMultiline() {
        return false;
    }
}

