/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.options;

import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UpdatableOptionSet
implements OptionSet {
    private Map<Class<? extends QuestOption<?>>, OptionWrapper> options = new HashMap();

    @Override
    public Iterator<QuestOption> iterator() {
        return this.options.values().stream().map(wrapper -> wrapper.option).iterator();
    }

    public void addOption(QuestOption option, Runnable update) {
        this.options.put(option.getClass(), new OptionWrapper(option, update));
    }

    @Override
    public <T extends QuestOption<?>> T getOption(Class<T> optionClass) {
        return (T)this.options.get(optionClass).option;
    }

    @Override
    public boolean hasOption(Class<? extends QuestOption<?>> clazz) {
        return this.options.containsKey(clazz);
    }

    public OptionWrapper getWrapper(Class<? extends QuestOption<?>> optionClass) {
        return this.options.get(optionClass);
    }

    public void calculateDependencies() {
        this.options.values().forEach(wrapper -> wrapper.dependent.clear());
        for (OptionWrapper wrapper2 : this.options.values()) {
            for (Class<QuestOption<?>> requiredOptionClass : wrapper2.option.getRequiredQuestOptions()) {
                this.options.get(requiredOptionClass).dependent.add(wrapper2.update);
            }
        }
    }

    public class OptionWrapper {
        public final QuestOption option;
        public final Runnable update;
        public final List<Runnable> dependent = new ArrayList<Runnable>();

        public OptionWrapper(QuestOption option, Runnable update) {
            this.option = option;
            this.update = update;
            option.setValueUpdaterListener(() -> {
                update.run();
                this.dependent.forEach(Runnable::run);
            });
        }
    }
}

