/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.options.description;

import fr.skytasul.quests.api.options.description.DescriptionSource;
import fr.skytasul.quests.api.options.description.QuestDescription;
import fr.skytasul.quests.api.options.description.QuestDescriptionProvider;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.questers.data.QuesterQuestData;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.utils.PlayerListCategory;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuestDescriptionContext {
    private final QuestDescription descriptionOptions;
    private final Quest quest;
    @Nullable
    private final Player player;
    private final Quester quester;
    private final PlayerListCategory category;
    private final DescriptionSource source;
    @Nullable
    private Optional<QuesterQuestData> cachedDatas;

    public QuestDescriptionContext(@NotNull QuestDescription descriptionOptions, @NotNull Quest quest, @Nullable Player player, @NotNull Quester quester, @NotNull PlayerListCategory category, @NotNull DescriptionSource source) {
        this.descriptionOptions = descriptionOptions;
        this.quest = quest;
        this.player = player;
        this.quester = quester;
        this.category = category;
        this.source = source;
    }

    @NotNull
    public QuestDescription getDescriptionOptions() {
        return this.descriptionOptions;
    }

    @NotNull
    public Quest getQuest() {
        return this.quest;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    @NotNull
    public Quester getQuester() {
        return this.quester;
    }

    @NotNull
    public PlayerListCategory getCategory() {
        return this.category;
    }

    @NotNull
    public DescriptionSource getSource() {
        return this.source;
    }

    @NotNull
    public Optional<QuesterQuestData> getQuestDatas() {
        if (this.cachedDatas == null) {
            this.cachedDatas = this.quester.getDataHolder().getQuestDataIfPresent(this.quest);
        }
        return this.cachedDatas;
    }

    public @NotNull List<@Nullable String> formatDescription() {
        ArrayList<String> list = new ArrayList<String>();
        this.quest.getDescriptions().stream().sorted(QuestDescriptionProvider.COMPARATOR).forEach(provider -> {
            List<String> description = provider.provideDescription(this);
            if (description == null || description.isEmpty()) {
                return;
            }
            if (!list.isEmpty() && provider.prefixDescriptionWithNewLine()) {
                list.add("");
            }
            list.addAll(description);
        });
        return list;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.descriptionOptions, this.quest, this.quester, this.category, this.source});
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof QuestDescriptionContext)) {
            return false;
        }
        QuestDescriptionContext context = (QuestDescriptionContext)obj;
        return this.descriptionOptions.equals(context.descriptionOptions) && this.quest.equals(context.quest) && this.quester.equals(context.quester) && this.category == context.category && this.source == context.source;
    }
}

