/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.pools;

import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.requirements.RequirementList;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface QuestPool
extends HasPlaceholders {
    public int getId();

    @Nullable
    public String getNpcId();

    @Nullable
    public String getHologram();

    public int getMaxQuests();

    public int getQuestsPerLaunch();

    public boolean isRedoAllowed();

    public long getTimeDiff();

    public boolean doAvoidDuplicates();

    @NotNull
    public RequirementList getRequirements();

    @NotNull
    public @NotNull List<@NotNull Quest> getQuests();

    public void addQuest(@NotNull Quest var1);

    public void removeQuest(@NotNull Quest var1);

    @NotNull
    public ItemStack getItemStack(@NotNull String var1);

    @NotNull
    public CompletableFuture<Boolean> resetPlayer(@NotNull Quester var1);

    public void resetPlayerTimer(@NotNull Quester var1);

    @NotNull
    public CanGiveResult canGive(@NotNull Player var1);

    @NotNull
    public CompletableFuture<String> give(@NotNull Player var1);

    public record CanGiveResult(boolean result, @Nullable String reason) {
    }
}

