/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.questers.data;

import fr.skytasul.quests.api.data.DataLoadingException;
import fr.skytasul.quests.api.data.DataSavingException;
import fr.skytasul.quests.api.questers.QuesterManager;
import fr.skytasul.quests.api.questers.data.QuesterData;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface QuesterDataManager {
    @NotNull
    public CompletableFuture<QuesterFetchResult> fetchQuester(@NotNull QuesterFetchRequest var1);

    public CompletableFuture<Integer> resetQuestData(int var1);

    public CompletableFuture<Integer> resetPoolData(int var1);

    public void load(@NotNull QuesterManager var1) throws DataLoadingException;

    public void save() throws DataSavingException;

    public void unload();

    @NotNull
    default public Iterator<? extends QuesterData> getAll() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("QuesterDataManager#getAll");
    }

    @NotNull
    default public CompletableFuture<ImportResult> importAll(@NotNull Iterator<? extends QuesterData> iterator) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("QuesterDataManager#importAll");
    }

    public record ImportResult(int questers, int failures) {
    }

    public record QuesterFetchResult(@NotNull Type type, @Nullable QuesterData dataHandler) {

        public static enum Type {
            SUCCESS_LOADED,
            SUCCESS_CREATED,
            FAILED_NOT_FOUND,
            FAILED;


            public boolean isSuccess() {
                return this == SUCCESS_LOADED || this == SUCCESS_CREATED;
            }
        }
    }

    public record QuesterFetchRequest(@NotNull Key providerKey, @NotNull String identifier, boolean createIfMissing, boolean shouldCache) {
    }
}

