/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.questers.data;

import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageIndex;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public interface QuesterQuestData {
    public int getQuestId();

    @Nullable
    public Quest getQuest();

    public void incrementFinished();

    public int getTimesFinished();

    default public boolean hasFinishedOnce() {
        return this.getTimesFinished() > 0;
    }

    public OptionalLong getTimer();

    public void setTimer(OptionalLong var1);

    public OptionalInt getBranch();

    public void setBranch(OptionalInt var1);

    public OptionalInt getStage();

    public void setStage(OptionalInt var1);

    @NotNull
    public State getState();

    public void setState(@NotNull State var1);

    default public boolean hasStarted() {
        return this.getState() != State.NOT_STARTED;
    }

    @Deprecated
    default public boolean isInQuestEnd() {
        return this.getState() == State.IN_END;
    }

    @Deprecated
    default public boolean isInEndingStages() {
        return this.getState() == State.IN_ENDING_STAGES;
    }

    public OptionalLong getStartingTime();

    public void setStartingTime(OptionalLong var1);

    @NotNull
    public @NotNull @UnmodifiableView Map<@NotNull Integer, Map<@NotNull String, @Nullable Object>> getAllStagesData();

    @Nullable
    public @Nullable @UnmodifiableView Map<@NotNull String, @Nullable Object> getStageData(int var1);

    public void setStageData(int var1, @Nullable @Nullable Map<@NotNull String, @Nullable Object> var2);

    @NotNull
    public @NotNull @UnmodifiableView Map<@NotNull String, @NotNull Object> getAllAdditionalData();

    @Nullable
    public <T> T getAdditionalData(@NotNull String var1);

    @Nullable
    public <T> T setAdditionalData(@NotNull String var1, @Nullable T var2);

    public void addQuestFlow(@NotNull StageController var1);

    public void resetQuestFlow();

    @NotNull
    public @UnmodifiableView List<StageIndex> getQuestFlow();

    @NotNull
    public Stream<StageController> getQuestFlowStages();

    @NotNull
    public CompletableFuture<Void> remove();

    public static enum State {
        NOT_STARTED,
        IN_REGULAR_STAGE,
        IN_ENDING_STAGES,
        IN_END;

    }
}

