/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.quests;

import fr.skytasul.quests.api.npcs.BqNpc;
import fr.skytasul.quests.api.options.OptionSet;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.options.description.DescriptionSource;
import fr.skytasul.quests.api.options.description.QuestDescriptionProvider;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.quests.branches.QuestBranchesManager;
import fr.skytasul.quests.api.quests.quester.QuestQuesterStrategy;
import fr.skytasul.quests.api.utils.QuestVisibilityLocation;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Quest
extends OptionSet,
Comparable<Quest>,
HasPlaceholders {
    public int getId();

    public boolean isValid();

    public void delete(boolean var1, boolean var2);

    @NotNull
    public QuestBranchesManager getBranchesManager();

    public void addOption(@NotNull QuestOption<?> var1);

    public void removeOption(@NotNull Class<? extends QuestOption<?>> var1);

    @NotNull
    public List<QuestDescriptionProvider> getDescriptions();

    @Nullable
    public String getName();

    @Nullable
    public String getDescription();

    @NotNull
    public ItemStack getQuestItem();

    @Nullable
    public BqNpc getStarterNpc();

    public boolean isScoreboardEnabled();

    public boolean isCancellable();

    public boolean isRepeatable();

    public boolean isHidden(QuestVisibilityLocation var1);

    public boolean isHiddenWhenRequirementsNotMet();

    public boolean canBypassLimit();

    public boolean hasStarted(@NotNull Quester var1);

    public boolean hasFinished(@NotNull Quester var1);

    @NotNull
    public String getDescriptionLine(@NotNull Quester var1, @NotNull DescriptionSource var2);

    public boolean canStart(@NotNull Player var1, boolean var2);

    public boolean cancelQuester(@NotNull Quester var1);

    @NotNull
    public CompletableFuture<Boolean> resetQuester(@NotNull Quester var1);

    @NotNull
    public CompletableFuture<Boolean> attemptStart(@NotNull Player var1);

    public void doNpcClick(@NotNull Player var1);

    public void start(@NotNull Quester var1, boolean var2);

    public void finish(@NotNull Quester var1);

    @NotNull
    public QuestQuesterStrategy getQuesterStrategy();
}

