/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.requirements;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObject;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.serializable.SerializableObject;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRequirement
extends QuestObject {
    protected static final String CUSTOM_REASON_KEY = "customReason";
    private String customReason;

    protected AbstractRequirement() {
        this((String)null, (String)null);
    }

    protected AbstractRequirement(@Nullable String customDescription, @Nullable String customReason) {
        super(QuestsAPI.getAPI().getRequirements(), customDescription);
        this.customReason = customReason;
    }

    @Nullable
    public String getCustomReason() {
        return this.customReason;
    }

    public void setCustomReason(@Nullable String customReason) {
        this.customReason = customReason;
    }

    public abstract boolean test(@NotNull Player var1);

    @Nullable
    public String getReason(@NotNull Player player) {
        Object reason = null;
        reason = !this.isValid() ? "\u00a7cerror: " + this.getInvalidReason() : (this.customReason != null ? this.customReason : this.getDefaultReason(player));
        if (reason != null && !((String)reason).isEmpty() && !"none".equals(reason)) {
            return MessageUtils.format((String)reason, this.getPlaceholdersRegistry());
        }
        return null;
    }

    @Nullable
    protected String getDefaultReason(@NotNull Player player) {
        return null;
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.register("custom_reason", () -> this.customReason);
    }

    @Nullable
    protected ClickType getCustomReasonClick() {
        return ClickType.SHIFT_RIGHT;
    }

    protected void sendCustomReasonHelpMessage(@NotNull Player p) {
        Lang.CHOOSE_REQUIREMENT_CUSTOM_REASON.send((CommandSender)p);
    }

    @Override
    protected void sendCustomDescriptionHelpMessage(@NotNull Player p) {
        Lang.CHOOSE_REQUIREMENT_CUSTOM_DESCRIPTION.send((CommandSender)p);
    }

    @Override
    protected final void clickInternal(@NotNull QuestObjectClickEvent event) {
        if (event.getClick() == this.getCustomReasonClick()) {
            this.sendCustomReasonHelpMessage(event.getPlayer());
            new TextEditor<String>(event.getPlayer(), event::reopenGUI, msg -> {
                this.setCustomReason((String)msg);
                event.reopenGUI();
            }).passNullIntoEndConsumer().start();
        } else {
            this.itemClick(event);
        }
    }

    protected abstract void itemClick(@NotNull QuestObjectClickEvent var1);

    @Override
    protected void addLore(@NotNull LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription(Lang.requirementReason.format((HasPlaceholders)PlaceholderRegistry.of("reason", this.customReason == null ? Lang.NotSet.toString() : this.customReason)));
        loreBuilder.addClick(this.getCustomReasonClick(), Lang.setRequirementReason.toString());
    }

    @Override
    @NotNull
    public abstract AbstractRequirement clone();

    @Override
    public void save(@NotNull ConfigurationSection section) {
        super.save(section);
        if (this.customReason != null) {
            section.set(CUSTOM_REASON_KEY, (Object)this.customReason);
        }
    }

    @Override
    public void load(@NotNull ConfigurationSection section) {
        super.load(section);
        if (section.contains(CUSTOM_REASON_KEY)) {
            this.customReason = section.getString(CUSTOM_REASON_KEY);
        }
    }

    @NotNull
    public static AbstractRequirement deserialize(Map<String, Object> map) {
        return SerializableObject.deserialize(map, QuestsAPI.getAPI().getRequirements());
    }
}

