/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.requirements;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.serializable.SerializableObject;
import fr.skytasul.quests.api.utils.messaging.MessageType;
import fr.skytasul.quests.api.utils.messaging.MessageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequirementList
extends ArrayList<AbstractRequirement> {
    private static final long serialVersionUID = 5568034962195448395L;

    public RequirementList() {
    }

    public RequirementList(@NotNull @NotNull Collection<@NotNull AbstractRequirement> requirements) {
        super(requirements);
    }

    @NotNull
    public MatchResult allMatch(@NotNull Player p) {
        boolean match = true;
        for (AbstractRequirement requirement : this) {
            try {
                if (requirement.isValid() && requirement.test(p)) continue;
                String reason = requirement.getReason(p);
                if (reason != null) {
                    return new MatchResult(false, reason);
                }
                match = false;
            }
            catch (Exception ex) {
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("Cannot test requirement " + requirement.getClass().getSimpleName() + " for player " + p.getName(), ex);
                return new MatchResult(false, "error");
            }
        }
        return new MatchResult(match, null);
    }

    public boolean allMatch(@NotNull Player p, boolean message) {
        MatchResult result = this.allMatch(p);
        if (message && result.reason() != null) {
            MessageUtils.sendMessage((CommandSender)p, result.reason(), (MessageType)MessageType.DefaultMessageType.PREFIXED);
        }
        return result.result();
    }

    public boolean anyMatch(@NotNull Player p) {
        for (AbstractRequirement requirement : this) {
            try {
                if (!requirement.isValid() || !requirement.test(p)) continue;
                return true;
            }
            catch (Exception ex) {
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("Cannot test requirement " + requirement.getClass().getSimpleName() + " for player " + p.getName(), ex);
            }
        }
        return false;
    }

    public void attachQuest(@NotNull Quest quest) {
        this.forEach((? super E requirement) -> requirement.attach(quest));
    }

    public void detachQuest() {
        this.forEach((? super E requirement) -> requirement.detach());
    }

    public String getSizeString() {
        return RequirementList.getSizeString(this.size());
    }

    @NotNull
    public List<Map<String, Object>> serialize() {
        return SerializableObject.serializeList(this);
    }

    public static RequirementList deserialize(@NotNull List<Map<?, ?>> mapList) {
        return new RequirementList((Collection<AbstractRequirement>)SerializableObject.deserializeList(mapList, AbstractRequirement::deserialize));
    }

    public static String getSizeString(int size) {
        return Lang.requirements.quickFormat("amount", size);
    }

    public record MatchResult(boolean result, @Nullable String reason) {
    }
}

