/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.requirements;

import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.NumberParser;
import fr.skytasul.quests.api.gui.LoreBuilder;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectClickEvent;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.utils.ComparisonMethod;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import java.text.NumberFormat;
import java.util.Objects;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TargetNumberRequirement
extends AbstractRequirement {
    protected ComparisonMethod comparison;
    protected double target;
    @NotNull
    private PlaceholderRegistry placeholders;

    protected TargetNumberRequirement(@Nullable String customDescription, @Nullable String customReason, double target, @NotNull ComparisonMethod comparison) {
        super(customDescription, customReason);
        this.target = target;
        this.comparison = Objects.requireNonNull(comparison);
    }

    public double getTarget() {
        return this.target;
    }

    @NotNull
    public ComparisonMethod getComparisonMethod() {
        return this.comparison;
    }

    @Override
    public boolean test(@NotNull Player p) {
        double diff = this.getPlayerTarget(p) - this.target;
        return this.comparison.test(diff);
    }

    @NotNull
    public String getShortFormattedValue() {
        return this.comparison.getSymbol() + " " + this.getNumberFormat().format(this.target);
    }

    @NotNull
    public String getFormattedValue() {
        return this.comparison.getTitle().format((HasPlaceholders)PlaceholderRegistry.of("number", this.getNumberFormat().format(this.target)));
    }

    @NotNull
    protected NumberFormat getNumberFormat() {
        return this.numberClass() == Integer.class ? NumberFormat.getIntegerInstance() : NumberFormat.getInstance();
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        placeholders.registerIndexed("short_" + this.getPlaceholderName(), this::getShortFormattedValue).register("long_" + this.getPlaceholderName(), this::getFormattedValue).register("raw_" + this.getPlaceholderName(), () -> this.getNumberFormat().format(this.target)).register(this.getPlaceholderName() + "_comparison", () -> Character.toString(this.comparison.getSymbol()));
    }

    @Override
    protected void addLore(@NotNull LoreBuilder loreBuilder) {
        super.addLore(loreBuilder);
        loreBuilder.addDescription(QuestOption.formatNullableValue(this.getFormattedValue()));
    }

    protected abstract String getPlaceholderName();

    public abstract double getPlayerTarget(@NotNull Player var1);

    @NotNull
    public abstract Class<? extends Number> numberClass();

    public abstract void sendHelpString(@NotNull Player var1);

    @Override
    public void save(@NotNull ConfigurationSection section) {
        super.save(section);
        section.set("comparison", (Object)this.comparison.name());
        section.set("target", (Object)this.target);
    }

    @Override
    public void load(@NotNull ConfigurationSection section) {
        super.load(section);
        if (section.contains("comparison")) {
            this.comparison = ComparisonMethod.valueOf(section.getString("comparison"));
        }
        this.target = section.getDouble("target");
    }

    @Override
    public void itemClick(@NotNull QuestObjectClickEvent event) {
        this.sendHelpString(event.getPlayer());
        new TextEditor<Number>(event.getPlayer(), () -> {
            if (this.target == 0.0) {
                event.getGUI().remove(this);
            }
            event.reopenGUI();
        }, number -> {
            this.target = number.doubleValue();
            Lang.COMPARISON_TYPE.send((CommandSender)event.getPlayer(), PlaceholderRegistry.of("available", ComparisonMethod.getComparisonParser().getNames(), "default", ComparisonMethod.GREATER_OR_EQUAL.name().toLowerCase()));
            new TextEditor<ComparisonMethod>(event.getPlayer(), null, comp -> {
                this.comparison = comp == null ? ComparisonMethod.GREATER_OR_EQUAL : comp;
                event.reopenGUI();
            }, ComparisonMethod.getComparisonParser()).passNullIntoEndConsumer().start();
        }, event::remove, new NumberParser<Number>(this.numberClass(), true)).start();
    }
}

