/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.rewards;

import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.rewards.AbstractReward;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class RewardGiveContext {
    @NotNull
    private final Quester quester;
    private boolean interrupBranch;
    private Map<Player, List<String>> earnings = new HashMap<Player, List<String>>();

    public RewardGiveContext(@NotNull Quester quester) {
        this.quester = quester;
    }

    @NotNull
    public Quester getQuester() {
        return this.quester;
    }

    public boolean isBranchInterrupted() {
        return this.interrupBranch;
    }

    public void interruptBranch() {
        this.interrupBranch = true;
    }

    @NotNull
    public @NotNull Map<Player, @NotNull List<String>> getEarnings() {
        return this.earnings;
    }

    public void addEarning(@NotNull Player player, @NotNull AbstractReward reward) {
        this.earnings.computeIfAbsent(player, __ -> new ArrayList()).add(reward.getDescription(player));
    }

    public void addEarning(@NotNull Player player, @NotNull String reward) {
        this.earnings.computeIfAbsent(player, __ -> new ArrayList()).add(reward);
    }

    public void addEarning(@NotNull AbstractReward reward) {
        for (Player player : this.quester.getOnlinePlayers()) {
            this.addEarning(player, reward);
        }
    }

    public void addEarning(@NotNull String reward) {
        for (Player player : this.quester.getOnlinePlayers()) {
            this.addEarning(player, reward);
        }
    }
}

