/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.rewards;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.players.PlayerQuester;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardGiveContext;
import fr.skytasul.quests.api.serializable.SerializableObject;
import fr.skytasul.quests.api.utils.messaging.DefaultErrors;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

@Unmodifiable
public class RewardList
extends AbstractList<AbstractReward> {
    @NotNull
    private final @NotNull List<@NotNull AbstractReward> rewards;
    private final boolean hasAsync;
    private final List<Quester> asyncQuesters;

    public RewardList() {
        this.rewards = List.of();
        this.hasAsync = false;
        this.asyncQuesters = null;
    }

    public RewardList(@NotNull @NotNull Collection<@NotNull AbstractReward> rewards) {
        this.rewards = List.of((AbstractReward[])rewards.toArray(AbstractReward[]::new));
        this.hasAsync = rewards.stream().anyMatch(AbstractReward::isAsync);
        this.asyncQuesters = new ArrayList<Quester>();
    }

    @NotNull
    public CompletableFuture<RewardsGiveResult> giveRewards(@NotNull Quester quester) {
        CompletableFuture<RewardsGiveResult> future = new CompletableFuture<RewardsGiveResult>();
        Runnable task = () -> {
            try {
                RewardGiveContext context = new RewardGiveContext(quester);
                for (AbstractReward reward : this.rewards) {
                    try {
                        reward.give(context);
                    }
                    catch (Exception ex) {
                        QuestsPlugin.getPlugin().getLoggerExpanded().severe("An exception occurred while giving a reward to {}", ex, quester.getDetailedName());
                    }
                }
                future.complete(new RewardsGiveResult(context.isBranchInterrupted(), context.getEarnings()));
            }
            catch (Throwable ex) {
                future.completeExceptionally(ex);
            }
            if (this.asyncQuesters != null) {
                this.asyncQuesters.remove(quester);
            }
        };
        if (this.hasAsync) {
            this.asyncQuesters.add(quester);
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)QuestsPlugin.getPlugin(), task);
        } else {
            task.run();
        }
        return future;
    }

    public void giveSubrewards(@NotNull Player player, RewardGiveContext context) {
        if (!context.getQuester().getOnlinePlayers().contains(player)) {
            throw new IllegalArgumentException("Player is not apart of the context's quester");
        }
        PlayerQuester playerQuester = PlayerManager.getPlayerAccount(player);
        try {
            this.giveRewards(playerQuester).get().mergeInContext(context);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException ex) {
            DefaultErrors.sendGeneric(playerQuester, "giving rewards");
            QuestsPlugin.getPlugin().getLoggerExpanded().severe("Failed to give rewards to {}", ex, playerQuester.getDetailedName());
        }
    }

    public boolean isInAsyncReward(@NotNull Quester quester) {
        return this.asyncQuesters != null && this.asyncQuesters.contains(quester);
    }

    public void attachQuest(@NotNull Quest quest) {
        this.rewards.forEach(reward -> reward.attach(quest));
    }

    public void detachQuest() {
        this.rewards.forEach(reward -> reward.detach());
    }

    public boolean hasAsync() {
        return this.hasAsync;
    }

    @Override
    public AbstractReward get(int index) {
        return this.rewards.get(index);
    }

    @Override
    public int size() {
        return this.rewards.size();
    }

    public String getSizeString() {
        return RewardList.getSizeString(this.rewards.size());
    }

    @NotNull
    public List<Map<String, Object>> serialize() {
        return SerializableObject.serializeList(this.rewards);
    }

    public static RewardList deserialize(@NotNull List<Map<?, ?>> mapList) {
        return new RewardList(SerializableObject.deserializeList(mapList, AbstractReward::deserialize));
    }

    public static String getSizeString(int size) {
        return Lang.rewards.quickFormat("amount", size);
    }

    public record RewardsGiveResult(boolean branchInterruption, Map<Player, List<String>> earnings) {
        @NotNull
        public List<String> getPlayerEarnings(@NotNull Player player) {
            return this.earnings.getOrDefault(player, List.of());
        }

        protected void mergeInContext(@NotNull RewardGiveContext context) {
            this.earnings.forEach((player, playerEarnings) -> playerEarnings.forEach(earning -> context.addEarning((Player)player, (String)earning)));
            if (this.branchInterruption) {
                context.interruptBranch();
            }
        }
    }
}

