/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.serializable;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.serializable.SerializableCreator;
import fr.skytasul.quests.api.serializable.SerializableRegistry;
import fr.skytasul.quests.api.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.MemoryConfiguration;
import org.jetbrains.annotations.NotNull;

public abstract class SerializableObject {
    @NotNull
    protected final SerializableCreator creator;

    protected SerializableObject(@NotNull SerializableRegistry registry) {
        this.creator = registry.getByClass(this.getClass());
        if (this.creator == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " has not been registered as an object.");
        }
    }

    protected SerializableObject(@NotNull SerializableCreator creator) {
        this.creator = creator;
        if (creator == null) {
            throw new IllegalArgumentException("Creator cannot be null.");
        }
    }

    @NotNull
    public SerializableCreator getCreator() {
        return this.creator;
    }

    @NotNull
    public String getName() {
        return this.creator.getID();
    }

    @NotNull
    public abstract SerializableObject clone();

    public abstract void save(@NotNull ConfigurationSection var1);

    public abstract void load(@NotNull ConfigurationSection var1);

    public final void serialize(@NotNull ConfigurationSection section) {
        section.set("id", (Object)this.creator.getID());
        this.save(section);
    }

    public static <T extends SerializableObject, C extends SerializableCreator<T>> T deserialize(@NotNull Map<String, Object> map, @NotNull SerializableRegistry<T, C> registry) {
        return SerializableObject.deserialize(Utils.createConfigurationSection(map), registry);
    }

    @NotNull
    public static <T extends SerializableObject, C extends SerializableCreator<T>> T deserialize(@NotNull ConfigurationSection section, @NotNull SerializableRegistry<T, C> registry) {
        SerializableCreator<Object> creator = null;
        String id = section.getString("id");
        if (id != null) {
            creator = (SerializableCreator<Object>)registry.getByID(id);
        }
        if (creator == null && section.contains("class")) {
            String className = section.getString("class");
            try {
                creator = registry.getByClass(Class.forName(className));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (creator == null) {
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("Cannot find object class " + className);
                return null;
            }
        }
        if (creator == null) {
            QuestsPlugin.getPlugin().getLoggerExpanded().severe("Cannot find object creator with id {} in registry {}", id, registry.getID());
            return null;
        }
        Object reward = creator.newObject();
        ((SerializableObject)reward).load(section);
        return reward;
    }

    @NotNull
    public static <T extends SerializableObject> List<T> deserializeList(@NotNull List<Map<?, ?>> objectList, @NotNull Function<Map<String, Object>, T> deserializeFunction) {
        ArrayList<SerializableObject> objects = new ArrayList<SerializableObject>(objectList.size());
        for (Map<?, ?> objectMap : objectList) {
            try {
                SerializableObject object = (SerializableObject)deserializeFunction.apply(objectMap);
                if (object == null) {
                    QuestsPlugin.getPlugin().notifyLoadingFailure();
                    QuestsPlugin.getPlugin().getLoggerExpanded().severe("The quest object for id " + String.valueOf(objectMap.get("id")) + " has not been deserialized.");
                    continue;
                }
                objects.add(object);
            }
            catch (Exception e) {
                QuestsPlugin.getPlugin().notifyLoadingFailure();
                QuestsPlugin.getPlugin().getLoggerExpanded().severe("An exception occured while deserializing a quest object (id " + String.valueOf(objectMap.get("id")) + ").", e);
            }
        }
        return objects;
    }

    @NotNull
    public static List<Map<String, Object>> serializeList(@NotNull List<? extends SerializableObject> objects) {
        return objects.stream().map(object -> {
            MemoryConfiguration section = new MemoryConfiguration();
            object.serialize((ConfigurationSection)section);
            return section.getValues(false);
        }).collect(Collectors.toList());
    }
}

