/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.serializable;

import fr.skytasul.quests.api.serializable.SerializableCreator;
import fr.skytasul.quests.api.serializable.SerializableObject;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SerializableRegistry<T extends SerializableObject, C extends SerializableCreator<T>>
implements Iterable<C> {
    protected final String id;
    protected final List<C> creators = new ArrayList<C>();
    protected final LoggerExpanded logger;

    public SerializableRegistry(@NotNull String id) {
        this.id = id;
        this.logger = LoggerExpanded.get("BeautyQuests.Registry " + id);
    }

    @NotNull
    public String getID() {
        return this.id;
    }

    public void register(@NotNull C creator) {
        if (this.creators.stream().anyMatch(x -> x.getID().equals(creator.getID()))) {
            throw new IllegalStateException("A creator with the same id " + ((SerializableCreator)creator).getID() + " has been registered.");
        }
        this.creators.add(creator);
        this.logger.debug("New object: id {0}, class {1}", ((SerializableCreator)creator).getID(), ((SerializableCreator)creator).getSerializableClass().getName());
    }

    @Nullable
    public C getByClass(@NotNull Class<?> clazz) {
        return (C)((SerializableCreator)this.creators.stream().filter(creator -> creator.getSerializableClass().equals(clazz)).findAny().orElse(null));
    }

    @Nullable
    public C getByID(@NotNull String id) {
        return (C)((SerializableCreator)this.creators.stream().filter(creator -> creator.getID().equals(id)).findAny().orElse(null));
    }

    @NotNull
    public List<C> getCreators() {
        return this.creators;
    }

    @Override
    public Iterator<C> iterator() {
        return this.creators.iterator();
    }
}

