/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.stages;

import fr.skytasul.quests.api.QuestsConfiguration;
import fr.skytasul.quests.api.players.PlayerManager;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.quests.Quest;
import fr.skytasul.quests.api.requirements.RequirementList;
import fr.skytasul.quests.api.rewards.RewardList;
import fr.skytasul.quests.api.serializable.SerializableCreator;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageDescriptionPlaceholdersContext;
import fr.skytasul.quests.api.stages.options.StageOption;
import fr.skytasul.quests.api.utils.AutoRegistered;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@AutoRegistered
public abstract class AbstractStage
implements HasPlaceholders {
    @NotNull
    protected final StageController controller;
    @Nullable
    private String startMessage = null;
    @Nullable
    private String customText = null;
    @NotNull
    private RewardList rewards = new RewardList();
    @NotNull
    private RequirementList validationRequirements = new RequirementList();
    @NotNull
    private @NotNull List<@NotNull StageOption> options;
    @Nullable
    private PlaceholderRegistry placeholders;

    protected AbstractStage(@NotNull StageController controller) {
        this.controller = controller;
        this.options = controller.getStageType().getOptionsRegistry().getCreators().stream().map(SerializableCreator::newObject).collect(Collectors.toList());
    }

    @NotNull
    public StageController getController() {
        return this.controller;
    }

    @NotNull
    public Quest getQuest() {
        return this.controller.getBranch().getQuest();
    }

    public void setStartMessage(@Nullable String text) {
        this.startMessage = text;
    }

    @Nullable
    public String getStartMessage() {
        return this.startMessage;
    }

    @NotNull
    public RewardList getRewards() {
        return this.rewards;
    }

    public void setRewards(@NotNull RewardList rewards) {
        this.rewards = rewards;
        rewards.attachQuest(this.getQuest());
    }

    @NotNull
    public RequirementList getValidationRequirements() {
        return this.validationRequirements;
    }

    public void setValidationRequirements(@NotNull RequirementList validationRequirements) {
        this.validationRequirements = validationRequirements;
        validationRequirements.attachQuest(this.getQuest());
    }

    @NotNull
    public @NotNull List<@NotNull StageOption> getOptions() {
        return this.options;
    }

    public void setOptions(@NotNull @NotNull List<@NotNull StageOption> options) {
        this.options = options;
    }

    @Nullable
    public String getCustomText() {
        return this.customText;
    }

    public void setCustomText(@Nullable String message) {
        this.customText = message;
    }

    public boolean sendStartMessage() {
        return this.startMessage == null && QuestsConfiguration.getConfig().getQuestsConfig().playerStageStartMessage();
    }

    @Override
    @NotNull
    public final PlaceholderRegistry getPlaceholdersRegistry() {
        if (this.placeholders == null) {
            this.placeholders = new PlaceholderRegistry();
            this.createdPlaceholdersRegistry(this.placeholders);
        }
        return this.placeholders;
    }

    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        placeholders.compose(false, this.controller.getBranch().getQuest());
        placeholders.register("stage_type", this.controller.getStageType().getName());
        placeholders.register("stage_rewards", this.rewards.getSizeString());
        placeholders.register("stage_requirements", this.validationRequirements.getSizeString());
    }

    protected final boolean matchesRequirements(@NotNull Player player) {
        return this.matchesRequirements(player, false);
    }

    protected final boolean matchesRequirements(@NotNull Player player, boolean msg) {
        return this.validationRequirements.allMatch(player, msg);
    }

    protected final boolean hasApplicableQuester(@NotNull Player player) {
        return this.controller.hasApplicableQuester(player);
    }

    protected final void finishStage(@NotNull Quester quester) {
        this.controller.finishStage(quester);
    }

    public void started(@NotNull Quester quester) {
    }

    public void ended(@NotNull Quester quester) {
    }

    public void joined(@NotNull Player player, @NotNull Quester quester) {
    }

    public void left(@NotNull Player player, @NotNull Quester quester) {
    }

    public void initPlayerDatas(@NotNull Quester acc, @NotNull @NotNull Map<@NotNull String, @Nullable Object> datas) {
    }

    @NotNull
    public abstract String getDefaultDescription(@NotNull StageDescriptionPlaceholdersContext var1);

    protected final void updateObjective(@NotNull Quester quester, @NotNull String dataKey, @Nullable Object dataValue) {
        this.controller.updateObjective(quester, dataKey, dataValue);
    }

    @Deprecated
    @Nullable
    protected final <T> T getData(@NotNull Player p, @NotNull String dataKey) {
        return this.getData(PlayerManager.getPlayerAccount(p), dataKey);
    }

    @Deprecated
    @Nullable
    protected final <T> T getData(@NotNull Quester acc, @NotNull String dataKey) {
        return this.getData(acc, dataKey, null);
    }

    @Nullable
    protected final <T> T getData(@NotNull Player p, @NotNull String dataKey, @NotNull Class<T> dataType) {
        return this.getData(PlayerManager.getPlayerAccount(p), dataKey, dataType);
    }

    @Nullable
    protected final <T> T getData(@NotNull Quester acc, @NotNull String dataKey, @NotNull Class<T> dataType) {
        return this.controller.getData(acc, dataKey, dataType);
    }

    public void unload() {
        this.rewards.detachQuest();
        this.validationRequirements.detachQuest();
    }

    public void load() {
    }

    protected void serialize(@NotNull ConfigurationSection section) {
    }

    public final void save(@NotNull ConfigurationSection section) {
        this.serialize(section);
        section.set("stageType", (Object)this.controller.getStageType().getID());
        section.set("customText", (Object)this.customText);
        if (this.startMessage != null) {
            section.set("text", (Object)this.startMessage);
        }
        if (!this.rewards.isEmpty()) {
            section.set("rewards", this.rewards.serialize());
        }
        if (!this.validationRequirements.isEmpty()) {
            section.set("requirements", this.validationRequirements.serialize());
        }
        this.options.stream().filter(StageOption::shouldSave).forEach(option -> option.save(section.createSection("options." + option.getCreator().getID())));
    }

    public final void load(@NotNull ConfigurationSection section) {
        if (section.contains("text")) {
            this.startMessage = section.getString("text");
        }
        if (section.contains("customText")) {
            this.customText = section.getString("customText");
        }
        if (section.contains("rewards")) {
            this.setRewards(RewardList.deserialize(section.getMapList("rewards")));
        }
        if (section.contains("requirements")) {
            this.setValidationRequirements(RequirementList.deserialize(section.getMapList("requirements")));
        }
        if (section.contains("options")) {
            ConfigurationSection optionsSection = section.getConfigurationSection("options");
            optionsSection.getKeys(false).forEach(optionID -> this.options.stream().filter(option -> option.getCreator().getID().equals(optionID)).findAny().ifPresent(option -> option.load(optionsSection.getConfigurationSection(optionID))));
        }
    }
}

