/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.stages;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface StageIndex {
    public static final Pattern FLOW_PATTERN = Pattern.compile("(\\d+):(E)?(\\d+)");

    @NotNull
    public String toString();

    @NotNull
    public static StageIndex fromString(@NotNull String string) throws IllegalArgumentException {
        Matcher matcher = FLOW_PATTERN.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid stage index string: " + string);
        }
        int branchId = Integer.parseInt(matcher.group(1));
        int stageId = Integer.parseInt(matcher.group(3));
        if (matcher.group(2) != null) {
            return new EndingStageIndex(branchId, stageId);
        }
        return new RegularStageIndex(branchId, stageId);
    }

    public record EndingStageIndex(int branch, int stageId) implements StageIndex
    {
        @Override
        public final String toString() {
            return "%d:E%d".formatted(this.branch, this.stageId);
        }
    }

    public record RegularStageIndex(int branch, int stageIndex) implements StageIndex
    {
        @Override
        public final String toString() {
            return "%d:%d".formatted(this.branch, this.stageIndex);
        }
    }
}

