/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.stages;

import fr.skytasul.quests.api.serializable.SerializableRegistry;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.options.StageOption;
import fr.skytasul.quests.api.stages.options.StageOptionCreator;
import fr.skytasul.quests.api.utils.messaging.HasPlaceholders;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class StageType<T extends AbstractStage>
implements HasPlaceholders {
    @NotNull
    private final String id;
    @NotNull
    private final Class<T> clazz;
    @NotNull
    private final String name;
    @NotNull
    private final StageLoader<T> loader;
    @NotNull
    private final ItemStack item;
    @NotNull
    private final StageCreationSupplier<T> creationSupplier;
    @NotNull
    private final SerializableRegistry<StageOption<T>, StageOptionCreator<T>> optionsRegistry;
    @NotNull
    private PlaceholderRegistry placeholders;

    public StageType(@NotNull String id, @NotNull Class<T> clazz, @NotNull String name, @NotNull StageLoader<T> loader, @NotNull ItemStack item, @NotNull StageCreationSupplier<T> creationSupplier) {
        this.id = id;
        this.clazz = clazz;
        this.name = name;
        this.item = item;
        this.loader = loader;
        this.creationSupplier = creationSupplier;
        this.optionsRegistry = new SerializableRegistry("stage-options-" + id);
    }

    @NotNull
    public String getID() {
        return this.id;
    }

    @NotNull
    public Class<T> getStageClass() {
        return this.clazz;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public StageLoader<T> getLoader() {
        return this.loader;
    }

    @NotNull
    public ItemStack getItem() {
        return this.item;
    }

    @NotNull
    public StageCreationSupplier<T> getCreationSupplier() {
        return this.creationSupplier;
    }

    @NotNull
    public SerializableRegistry<StageOption<T>, StageOptionCreator<T>> getOptionsRegistry() {
        return this.optionsRegistry;
    }

    @Override
    @NotNull
    public PlaceholderRegistry getPlaceholdersRegistry() {
        return PlaceholderRegistry.of("stage_type", this.name, "stage_type_id", this.id);
    }

    @FunctionalInterface
    public static interface StageLoader<T extends AbstractStage> {
        @NotNull
        public T supply(@NotNull ConfigurationSection var1, @NotNull StageController var2);
    }

    @FunctionalInterface
    public static interface StageCreationSupplier<T extends AbstractStage> {
        @NotNull
        public StageCreation<T> supply(@NotNull StageCreationContext<T> var1);
    }
}

