/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.stages;

import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageType;
import fr.skytasul.quests.api.stages.options.StageOptionAutoRegister;
import fr.skytasul.quests.api.utils.logger.LoggerExpanded;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.NotNull;

public class StageTypeRegistry
implements Iterable<StageType<?>> {
    private static final LoggerExpanded LOGGER = LoggerExpanded.get("BeautyQuests.Stages");
    @NotNull
    private final @NotNull List<@NotNull StageType<?>> types = new ArrayList();
    @NotNull
    private final @NotNull List<@NotNull StageOptionAutoRegister> autoRegisteringOptions = new ArrayList<StageOptionAutoRegister>(2);

    public void register(@NotNull StageType<? extends AbstractStage> type) {
        Validate.notNull(type);
        this.types.add(type);
        LOGGER.debug("Registered ({0}, {1})", type.getName(), this.types.indexOf(type));
        for (StageOptionAutoRegister autoRegister : this.autoRegisteringOptions) {
            this.applyAutoregisteringOptions(type, autoRegister);
        }
    }

    private <T extends AbstractStage> void applyAutoregisteringOptions(@NotNull StageType<T> type, @NotNull StageOptionAutoRegister autoRegister) {
        if (autoRegister.appliesTo(type)) {
            type.getOptionsRegistry().register(autoRegister.createOptionCreator(type));
        }
    }

    public void autoRegisterOption(@NotNull StageOptionAutoRegister autoRegister) {
        Validate.notNull((Object)autoRegister);
        this.autoRegisteringOptions.add(autoRegister);
        for (StageType<?> type : this.types) {
            this.applyAutoregisteringOptions(type, autoRegister);
        }
    }

    @NotNull
    public @NotNull List<@NotNull StageType<?>> getTypes() {
        return this.types;
    }

    @NotNull
    public <T extends AbstractStage> Optional<StageType<T>> getType(@NotNull Class<T> stageClass) {
        return this.types.stream().filter(type -> type.getStageClass() == stageClass).map(type -> type).findAny();
    }

    @NotNull
    public Optional<StageType<?>> getType(@NotNull String id) {
        return this.types.stream().filter(type -> type.getID().equals(id)).findAny();
    }

    @Override
    public Iterator<StageType<?>> iterator() {
        return this.types.iterator();
    }
}

