/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.stages.creation;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.objects.QuestObjectLocation;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.requirements.AbstractRequirement;
import fr.skytasul.quests.api.requirements.RequirementList;
import fr.skytasul.quests.api.rewards.AbstractReward;
import fr.skytasul.quests.api.rewards.RewardList;
import fr.skytasul.quests.api.serializable.SerializableCreator;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.stages.options.StageOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class StageCreation<T extends AbstractStage> {
    protected static final int SLOT_REWARDS = 1;
    protected static final int SLOT_DESCRIPTION = 2;
    protected static final int SLOT_MESSAGE = 3;
    protected static final int SLOT_REQUIREMENTS = 4;
    private static final ItemStack ENDING_ITEM = ItemUtils.item(XMaterial.BAKED_POTATO, Lang.ending.toString(), new String[0]);
    private static final ItemStack DESCRITPION_MESSAGE_ITEM = ItemUtils.item(XMaterial.OAK_SIGN, Lang.descMessage.toString(), new String[0]);
    private static final ItemStack START_MESSAGE_ITEM = ItemUtils.item(XMaterial.FEATHER, Lang.startMsg.toString(), new String[0]);
    private static final ItemStack VALIDATION_REQUIREMENTS_ITEM = ItemUtils.item(XMaterial.NETHER_STAR, Lang.validationRequirements.toString(), QuestOption.formatDescription(Lang.validationRequirementsLore.toString()));
    @NotNull
    protected final StageCreationContext<T> context;
    private List<AbstractReward> rewards;
    private List<AbstractRequirement> requirements;
    private List<StageOption<T>> options;
    private String customDescription;
    private String startMessage;

    protected StageCreation(@NotNull StageCreationContext<T> context) {
        this.context = context;
    }

    @NotNull
    public StageCreationContext<T> getCreationContext() {
        return this.context;
    }

    @NotNull
    public StageGuiLine getLine() {
        return this.context.getLine();
    }

    public List<AbstractReward> getRewards() {
        return this.rewards;
    }

    public void setRewards(List<AbstractReward> rewards) {
        this.rewards = rewards;
        this.getLine().refreshItemLore(1, QuestOption.formatDescription(RewardList.getSizeString(rewards.size())));
    }

    public List<AbstractRequirement> getRequirements() {
        return this.requirements;
    }

    public void setRequirements(List<AbstractRequirement> requirements) {
        this.getLine().refreshItemLore(4, QuestOption.formatDescription(RequirementList.getSizeString(requirements.size())));
        this.requirements = requirements;
    }

    public String getCustomDescription() {
        return this.customDescription;
    }

    public void setCustomDescription(String customDescription) {
        this.customDescription = customDescription;
        this.getLine().refreshItemLore(2, QuestOption.formatNullableValue(customDescription));
    }

    public String getStartMessage() {
        return this.startMessage;
    }

    public void setStartMessage(String startMessage) {
        this.startMessage = startMessage;
        this.getLine().refreshItemLore(3, QuestOption.formatNullableValue(startMessage));
    }

    public void setupLine(@NotNull StageGuiLine line) {
        line.setItem(1, ENDING_ITEM.clone(), event -> QuestsAPI.getAPI().getRewards().createGUI(QuestObjectLocation.STAGE, rewards -> {
            this.setRewards((List<AbstractReward>)rewards);
            event.reopen();
        }, this.rewards).open(event.getPlayer()));
        line.setItem(2, DESCRITPION_MESSAGE_ITEM.clone(), event -> {
            Lang.DESC_MESSAGE.send((CommandSender)event.getPlayer());
            new TextEditor<String>(event.getPlayer(), event::reopen, obj -> {
                this.setCustomDescription((String)obj);
                event.reopen();
            }).passNullIntoEndConsumer().start();
        });
        line.setItem(3, START_MESSAGE_ITEM.clone(), event -> {
            Lang.START_TEXT.send((CommandSender)event.getPlayer());
            new TextEditor<String>(event.getPlayer(), event::reopen, obj -> {
                this.setStartMessage((String)obj);
                event.reopen();
            }).passNullIntoEndConsumer().start();
        });
        line.setItem(4, VALIDATION_REQUIREMENTS_ITEM.clone(), event -> QuestsAPI.getAPI().getRequirements().createGUI(QuestObjectLocation.STAGE, requirements -> {
            this.setRequirements((List<AbstractRequirement>)requirements);
            event.reopen();
        }, this.requirements).open(event.getPlayer()));
    }

    public void start(@NotNull Player p) {
        this.setRewards(new ArrayList<AbstractReward>());
        this.setRequirements(new ArrayList<AbstractRequirement>());
        this.setCustomDescription(null);
        this.setStartMessage(null);
        this.options = this.context.getType().getOptionsRegistry().getCreators().stream().map(SerializableCreator::newObject).collect(Collectors.toList());
        this.options.forEach(option -> option.startEdition(this));
    }

    public void edit(@NotNull T stage) {
        this.setRewards(((AbstractStage)stage).getRewards());
        this.setRequirements(((AbstractStage)stage).getValidationRequirements());
        this.setStartMessage(((AbstractStage)stage).getStartMessage());
        this.setCustomDescription(((AbstractStage)stage).getCustomText());
        this.options = ((AbstractStage)stage).getOptions().stream().map(StageOption::clone).map(x -> x).collect(Collectors.toList());
        this.options.forEach(option -> option.startEdition(this));
    }

    @NotNull
    public final T finish(@NotNull StageController branch) {
        T stage = this.finishStage(branch);
        ((AbstractStage)stage).setRewards(new RewardList(this.rewards));
        ((AbstractStage)stage).setValidationRequirements(new RequirementList((Collection<AbstractRequirement>)this.requirements));
        ((AbstractStage)stage).setCustomText(this.customDescription);
        ((AbstractStage)stage).setStartMessage(this.startMessage);
        ((AbstractStage)stage).setOptions(this.options);
        return stage;
    }

    @NotNull
    protected abstract T finishStage(@NotNull StageController var1);
}

