/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.stages.options;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.serializable.SerializableObject;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.StageHandler;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StageOption<T extends AbstractStage>
extends SerializableObject
implements StageHandler {
    @NotNull
    private final Class<? extends T> stageClass;
    @Nullable
    private StageController controller;

    protected StageOption(@NotNull Class<? extends T> stageClass) {
        super(QuestsAPI.getAPI().getStages().getType(stageClass).orElseThrow(() -> new IllegalArgumentException(stageClass.getName() + "has not been registered as a stage type via the API.")).getOptionsRegistry());
        this.stageClass = stageClass;
    }

    @NotNull
    public Class<? extends T> getStageClass() {
        return this.stageClass;
    }

    @Override
    public void stageLoad(@NotNull StageController stage) {
        if (this.controller != null) {
            throw new IllegalArgumentException("Stage already loaded");
        }
        this.controller = stage;
    }

    @Override
    public void stageUnload(@NotNull StageController stage) {
        if (this.controller == null) {
            throw new IllegalArgumentException("Stage was not loaded");
        }
        this.controller = null;
    }

    @NotNull
    public Optional<StageController> getStageController() {
        return Optional.ofNullable(this.controller);
    }

    @Override
    @NotNull
    public abstract StageOption<T> clone();

    public abstract void startEdition(@NotNull StageCreation<T> var1);

    public abstract boolean shouldSave();
}

