/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.stages.types;

import fr.skytasul.quests.api.QuestsAPI;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.blocks.BQBlock;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.stages.types.AbstractCountableStage;
import fr.skytasul.quests.api.utils.CountableObject;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractCountableBlockStage
extends AbstractCountableStage<BQBlock> {
    protected AbstractCountableBlockStage(@NotNull StageController controller, @NotNull @NotNull List<@NotNull CountableObject<BQBlock>> objects) {
        super(controller, objects);
    }

    @Override
    protected boolean objectApplies(@NotNull BQBlock object, Object other) {
        if (other instanceof Block) {
            return object.applies((Block)other);
        }
        return super.objectApplies(object, other);
    }

    @Override
    @NotNull
    protected String getPlaceholderKey() {
        return "blocks";
    }

    @Override
    @NotNull
    protected String getName(@NotNull BQBlock object) {
        return object.getName();
    }

    @Override
    @NotNull
    protected Object serialize(@NotNull BQBlock object) {
        return object.getAsString();
    }

    @Override
    @NotNull
    protected BQBlock deserialize(@NotNull Object object) {
        return QuestsAPI.getAPI().getBlocksManager().deserialize((String)object);
    }

    public static abstract class AbstractCreator<T extends AbstractCountableBlockStage>
    extends StageCreation<T> {
        protected List<CountableObject.MutableCountableObject<BQBlock>> blocks;

        protected AbstractCreator(@NotNull StageCreationContext<T> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(this.getBlocksSlot(), this.getBlocksItem(), event -> QuestsPlugin.getPlugin().getGuiManager().getFactory().createBlocksSelection(obj -> {
                this.setBlocks((List<CountableObject.MutableCountableObject<BQBlock>>)obj);
                event.reopen();
            }, this.blocks).open(event.getPlayer()));
        }

        public List<CountableObject<BQBlock>> getImmutableBlocks() {
            return this.blocks.stream().map(CountableObject.MutableCountableObject::toImmutable).collect(Collectors.toList());
        }

        protected abstract ItemStack getBlocksItem();

        protected int getBlocksSlot() {
            return 7;
        }

        public void setBlocks(List<CountableObject.MutableCountableObject<BQBlock>> blocks) {
            this.blocks = blocks;
            this.getLine().refreshItemLoreOptionValue(this.getBlocksSlot(), blocks.size() + " blocks");
        }

        @Override
        public void start(Player p) {
            super.start(p);
            QuestsPlugin.getPlugin().getGuiManager().getFactory().createBlocksSelection(obj -> {
                this.setBlocks((List<CountableObject.MutableCountableObject<BQBlock>>)obj);
                this.context.reopenGui();
            }, Collections.emptyList()).open(p);
        }

        @Override
        public void edit(T stage) {
            super.edit(stage);
            this.setBlocks(((AbstractCountableStage)stage).getMutableObjects());
        }
    }
}

