/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.stages.types;

import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.utils.CountableObject;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.progress.ProgressPlaceholders;
import fr.skytasul.quests.api.utils.progress.itemdescription.HasItemsDescriptionConfiguration;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

public abstract class AbstractCountableStage<T>
extends AbstractStage
implements HasItemsDescriptionConfiguration.HasMultipleObjects<T> {
    @NotNull
    protected final @NotNull List<@NotNull CountableObject<T>> objects;

    protected AbstractCountableStage(@NotNull StageController controller, @NotNull @NotNull List<@NotNull CountableObject<T>> objects) {
        super(controller);
        this.objects = objects;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull CountableObject<T>> getObjects() {
        return this.objects;
    }

    @NotNull
    public @NotNull List<@NotNull CountableObject.MutableCountableObject<T>> getMutableObjects() {
        return this.objects.stream().map(countable -> CountableObject.createMutable(countable.getUUID(), this.cloneObject(countable.getObject()), countable.getAmount())).collect(Collectors.toList());
    }

    @NotNull
    public Optional<CountableObject<T>> getObject(@NotNull UUID uuid) {
        return this.objects.stream().filter(object -> object.getUUID().equals(uuid)).findAny();
    }

    @Deprecated
    public Map<Integer, Map.Entry<T, Integer>> cloneObjects() {
        HashMap<Integer, Map.Entry<T, Integer>> map = new HashMap<Integer, Map.Entry<T, Integer>>();
        for (int id = 0; id < this.objects.size(); ++id) {
            CountableObject<T> object = this.objects.get(id);
            map.put(id, new AbstractMap.SimpleEntry<T, Integer>(this.cloneObject(object.getObject()), object.getAmount()));
        }
        return map;
    }

    @NotNull
    protected @NotNull Map<@NotNull UUID, @NotNull Integer> getRawRemainingAmounts(@NotNull Quester quester, boolean warnNull) {
        Map remaining = this.getData(quester, "remaining", Map.class);
        if (warnNull && remaining == null) {
            QuestsPlugin.getPlugin().getLoggerExpanded().namedWarning("Cannot retrieve remaining amounts for {} on {}", "data" + quester.getIdentifier() + this.controller.toString(), 10, quester.getDetailedName(), this.controller);
        }
        if (remaining == null || remaining.isEmpty()) {
            return Collections.emptyMap();
        }
        Object object = remaining.keySet().iterator().next();
        if (object instanceof Integer) {
            HashMap<UUID, Integer> newRemaining = new HashMap<UUID, Integer>(remaining.size());
            HashMap dataMap = new HashMap(remaining.size());
            remaining.forEach((key, amount) -> {
                UUID uuid = AbstractCountableStage.uuidFromLegacyIndex((Integer)key);
                if (!this.getObject(uuid).isPresent()) {
                    QuestsPlugin.getPlugin().getLoggerExpanded().warning("Cannot migrate {} data for stage {} as there is no migrated data for object {}", quester.getDetailedName(), this.toString(), key);
                }
                newRemaining.put(uuid, (Integer)amount);
                dataMap.put(uuid.toString(), amount);
            });
            this.updateObjective(quester, "remaining", dataMap);
            return newRemaining;
        }
        if (object instanceof String) {
            return remaining.entrySet().stream().collect(Collectors.toMap(entry -> UUID.fromString((String)entry.getKey()), Map.Entry::getValue));
        }
        throw new UnsupportedOperationException(object.getClass().getName());
    }

    @Override
    @NotNull
    public Map<CountableObject<T>, Integer> getRemainingAmounts(@NotNull Quester quester) {
        Map<@NotNull UUID, @NotNull Integer> remainings = this.getRawRemainingAmounts(quester, false);
        HashMap<CountableObject<T>, Integer> amounts = new HashMap<CountableObject<T>, Integer>(remainings.size());
        remainings.forEach((uuid, remaining) -> {
            Optional<CountableObject<T>> object = this.getObject((UUID)uuid);
            if (object.isPresent()) {
                amounts.put(object.get(), (Integer)remaining);
            } else {
                QuestsPlugin.getPlugin().getLogger().info("Cannot find object with UUID " + String.valueOf(uuid) + " in " + String.valueOf(this.controller));
            }
        });
        return amounts;
    }

    @Override
    @Nullable
    public CountableObject<T> getObject(int index) {
        return index >= this.objects.size() ? null : this.objects.get(index);
    }

    @Override
    public long getRemainingAmount(@NotNull Quester quester, CountableObject<T> object) {
        return this.getRawRemainingAmounts(quester, false).get(object.getUUID()).intValue();
    }

    @Override
    public long getRemainingAmount(@NotNull Quester quester) {
        return this.getRawRemainingAmounts(quester, false).values().stream().mapToInt(Integer::intValue).sum();
    }

    @Override
    public long getTotalAmount() {
        return this.objects.stream().mapToInt(CountableObject::getAmount).sum();
    }

    @Override
    @NotNull
    public String getObjectName(CountableObject<T> object) {
        return this.getName(object.getObject());
    }

    protected void updateRemaining(@NotNull Quester quester, @NotNull @NotNull Map<@NotNull UUID, @NotNull Integer> remaining) {
        this.updateObjective(quester, "remaining", remaining.entrySet().stream().collect(Collectors.toMap(entry -> ((UUID)entry.getKey()).toString(), Map.Entry::getValue)));
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        ProgressPlaceholders.registerObjects(placeholders, this.getPlaceholderKey(), this);
    }

    @Override
    public void initPlayerDatas(@NotNull Quester acc, @NotNull @NotNull Map<@NotNull String, @Nullable Object> datas) {
        super.initPlayerDatas(acc, datas);
        datas.put("remaining", this.objects.stream().collect(Collectors.toMap(object -> object.getUUID().toString(), CountableObject::getAmount)));
    }

    public boolean event(@NotNull Player p, @UnknownNullability Object object, int amount) {
        if (amount < 0) {
            throw new IllegalArgumentException("Event amount must be positive (" + amount + ")");
        }
        if (!this.matchesRequirements(p) || !this.hasApplicableQuester(p)) {
            return true;
        }
        Collection<Quester> questers = this.controller.getApplicableQuesters(p);
        for (CountableObject<T> countableObject : this.objects) {
            if (!this.objectApplies(countableObject.getObject(), object)) continue;
            Iterator<Quester> iterator = questers.iterator();
            while (iterator.hasNext()) {
                Quester quester = iterator.next();
                Map<UUID, Integer> playerAmounts = this.getRawRemainingAmounts(quester, true);
                if (!playerAmounts.containsKey(countableObject.getUUID())) continue;
                int playerAmount = playerAmounts.remove(countableObject.getUUID());
                if (playerAmount > amount) {
                    playerAmounts.put(countableObject.getUUID(), playerAmount - amount);
                }
                if (playerAmounts.isEmpty()) {
                    this.finishStage(quester);
                    iterator.remove();
                    continue;
                }
                this.updateRemaining(quester, playerAmounts);
            }
        }
        return questers.isEmpty();
    }

    protected boolean objectApplies(@NotNull T object, @UnknownNullability Object other) {
        return object.equals(other);
    }

    @NotNull
    protected T cloneObject(@NotNull T object) {
        return object;
    }

    @NotNull
    protected abstract String getPlaceholderKey();

    @NotNull
    protected abstract String getName(@NotNull T var1);

    @NotNull
    protected abstract Object serialize(@NotNull T var1);

    @NotNull
    protected abstract T deserialize(@NotNull Object var1);

    @Override
    protected void serialize(@NotNull ConfigurationSection section) {
        ConfigurationSection objectsSection = section.createSection("objects");
        for (CountableObject<T> obj : this.objects) {
            ConfigurationSection objectSection = objectsSection.createSection(obj.getUUID().toString());
            objectSection.set("amount", (Object)obj.getAmount());
            objectSection.set("object", this.serialize(obj.getObject()));
        }
    }

    protected void deserialize(@NotNull ConfigurationSection section) {
        ConfigurationSection objectsSection = section.getConfigurationSection("objects");
        if (objectsSection != null) {
            for (String key : objectsSection.getKeys(false)) {
                UUID uuid;
                try {
                    uuid = UUID.fromString(key);
                }
                catch (IllegalArgumentException ex) {
                    uuid = AbstractCountableStage.uuidFromLegacyIndex(Integer.parseInt(key));
                }
                ConfigurationSection objectSection = objectsSection.getConfigurationSection(key);
                Object serialized = objectSection.get("object");
                if (serialized instanceof ConfigurationSection) {
                    serialized = ((ConfigurationSection)serialized).getValues(false);
                }
                this.objects.add(CountableObject.create(uuid, this.deserialize(serialized), objectSection.getInt("amount")));
            }
        }
        if (this.objects.isEmpty()) {
            QuestsPlugin.getPlugin().getLoggerExpanded().warning("Stage with no content: " + this.toString());
        }
    }

    private static UUID uuidFromLegacyIndex(int index) {
        return new UUID(index, 2478L);
    }
}

