/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.stages.types;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.editors.TextEditor;
import fr.skytasul.quests.api.editors.parsers.NumberParser;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.questers.Quester;
import fr.skytasul.quests.api.stages.AbstractStage;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.stages.types.Locatable;
import fr.skytasul.quests.api.utils.MinecraftNames;
import fr.skytasul.quests.api.utils.messaging.PlaceholderRegistry;
import fr.skytasul.quests.api.utils.progress.ProgressPlaceholders;
import fr.skytasul.quests.api.utils.progress.itemdescription.HasItemsDescriptionConfiguration;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Spliterator;
import java.util.Spliterators;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Locatable.LocatableType(types={Locatable.LocatedType.ENTITY})
public abstract class AbstractEntityStage
extends AbstractStage
implements Locatable.MultipleLocatable,
HasItemsDescriptionConfiguration.HasSingleObject {
    @NotNull
    protected final EntityType entity;
    protected final int amount;

    protected AbstractEntityStage(@NotNull StageController controller, @NotNull EntityType entity, int amount) {
        super(controller);
        this.entity = entity;
        this.amount = amount;
    }

    protected void event(@NotNull Player p, @NotNull EntityType type) {
        if (this.matchesRequirements(p) && (this.entity == null || type.equals((Object)this.entity))) {
            for (Quester quester : this.controller.getApplicableQuesters(p)) {
                OptionalInt playerAmount = this.getRemainingAmountOptional(quester);
                if (!playerAmount.isPresent()) {
                    QuestsPlugin.getPlugin().getLoggerExpanded().warning(p.getName() + " does not have object datas for stage " + this.toString() + ". This is a bug!");
                    continue;
                }
                if (playerAmount.getAsInt() <= 1) {
                    this.finishStage(quester);
                    continue;
                }
                this.updateObjective(quester, "amount", playerAmount.getAsInt() - 1);
            }
        }
    }

    @NotNull
    protected OptionalInt getRemainingAmountOptional(@NotNull Quester acc) {
        Integer amount = this.getData(acc, "amount", Integer.class);
        return amount == null ? OptionalInt.empty() : OptionalInt.of(amount);
    }

    @Override
    public long getRemainingAmount(@NotNull Quester quester) {
        return this.getRemainingAmountOptional(quester).orElse(0);
    }

    @Override
    public long getObjectAmount() {
        return this.amount;
    }

    @Override
    @NotNull
    public String getObjectName() {
        return this.entity == null ? Lang.EntityTypeAny.toString() : MinecraftNames.getEntityName(this.entity);
    }

    @Override
    public void initPlayerDatas(@NotNull Quester acc, @NotNull @NotNull Map<@NotNull String, @Nullable Object> datas) {
        super.initPlayerDatas(acc, datas);
        datas.put("amount", this.amount);
    }

    @Override
    protected void serialize(@NotNull ConfigurationSection section) {
        section.set("entityType", (Object)(this.entity == null ? "any" : this.entity.name()));
        section.set("amount", (Object)this.amount);
    }

    @Override
    protected void createdPlaceholdersRegistry(@NotNull PlaceholderRegistry placeholders) {
        super.createdPlaceholdersRegistry(placeholders);
        ProgressPlaceholders.registerObject(placeholders, "mobs", this);
    }

    @Override
    public boolean canBeFetchedAsynchronously() {
        return false;
    }

    @Override
    @NotNull
    public @NotNull Spliterator< @NotNull Locatable.Located> getNearbyLocated(@NotNull Locatable.MultipleLocatable.NearbyFetcher fetcher) {
        if (!fetcher.isTargeting(Locatable.LocatedType.ENTITY)) {
            return Spliterators.emptySpliterator();
        }
        return fetcher.getCenter().getWorld().getEntitiesByClass(this.entity.getEntityClass()).stream().map(x -> {
            double ds = x.getLocation().distanceSquared(fetcher.getCenter());
            if (ds > fetcher.getMaxDistanceSquared()) {
                return null;
            }
            return new AbstractMap.SimpleEntry<Entity, Double>((Entity)x, ds);
        }).filter(Objects::nonNull).sorted(Comparator.comparing(Map.Entry::getValue)).map(entry -> Locatable.Located.LocatedEntity.create((Entity)entry.getKey())).spliterator();
    }

    public static abstract class AbstractCreator<T extends AbstractEntityStage>
    extends StageCreation<T> {
        protected EntityType entity = null;
        protected int amount = 1;

        protected AbstractCreator(@NotNull StageCreationContext<T> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(6, ItemUtils.item(XMaterial.CHICKEN_SPAWN_EGG, Lang.changeEntityType.toString(), new String[0]), event -> QuestsPlugin.getPlugin().getGuiManager().getFactory().createEntityTypeSelection(x -> {
                this.setEntity((EntityType)x);
                event.reopen();
            }, x -> x == null ? this.canBeAnyEntity() : this.canUseEntity((EntityType)x)).open(event.getPlayer()));
            line.setItem(7, ItemUtils.item(XMaterial.REDSTONE, Lang.Amount.quickFormat("amount", 1), new String[0]), event -> new TextEditor<Integer>(event.getPlayer(), event::reopen, x -> {
                this.setAmount((int)x);
                event.reopen();
            }, NumberParser.INTEGER_PARSER_STRICT_POSITIVE).start());
        }

        public void setEntity(EntityType entity) {
            this.entity = entity;
            this.getLine().refreshItemLoreOptionValue(6, entity == null ? Lang.EntityTypeAny.toString() : entity.name());
        }

        public void setAmount(int amount) {
            this.amount = amount;
            this.getLine().refreshItemName(7, Lang.Amount.quickFormat("amount", amount));
        }

        @Override
        public void start(Player p) {
            super.start(p);
            this.setEntity(null);
        }

        @Override
        public void edit(T stage) {
            super.edit(stage);
            this.setEntity(((AbstractEntityStage)stage).entity);
            this.setAmount(((AbstractEntityStage)stage).amount);
        }

        protected boolean canBeAnyEntity() {
            return true;
        }

        protected abstract boolean canUseEntity(@NotNull EntityType var1);
    }
}

