/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.stages.types;

import com.cryptomorin.xseries.XMaterial;
import fr.skytasul.quests.api.QuestsPlugin;
import fr.skytasul.quests.api.comparison.ItemComparisonMap;
import fr.skytasul.quests.api.gui.ItemUtils;
import fr.skytasul.quests.api.localization.Lang;
import fr.skytasul.quests.api.options.QuestOption;
import fr.skytasul.quests.api.stages.StageController;
import fr.skytasul.quests.api.stages.creation.StageCreation;
import fr.skytasul.quests.api.stages.creation.StageCreationContext;
import fr.skytasul.quests.api.stages.creation.StageGuiLine;
import fr.skytasul.quests.api.stages.types.AbstractCountableStage;
import fr.skytasul.quests.api.utils.CountableObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractItemStage
extends AbstractCountableStage<ItemStack> {
    @NotNull
    protected final ItemComparisonMap comparisons;

    protected AbstractItemStage(@NotNull StageController controller, @NotNull @NotNull List<@NotNull CountableObject<ItemStack>> objects, ItemComparisonMap comparisons) {
        super(controller, objects);
        this.comparisons = comparisons;
    }

    protected AbstractItemStage(@NotNull StageController controller, @NotNull ConfigurationSection section) {
        super(controller, new ArrayList());
        this.comparisons = section.contains("itemComparisons") ? new ItemComparisonMap(section.getConfigurationSection("itemComparisons")) : new ItemComparisonMap();
        super.deserialize(section);
    }

    @Override
    @NotNull
    protected String getPlaceholderKey() {
        return "items";
    }

    @Override
    @NotNull
    protected ItemStack cloneObject(@NotNull ItemStack object) {
        return object.clone();
    }

    @Override
    protected boolean objectApplies(@NotNull ItemStack object, @NotNull Object other) {
        return this.comparisons.isSimilar(object, (ItemStack)other);
    }

    @Override
    @NotNull
    protected String getName(@NotNull ItemStack object) {
        return ItemUtils.getName(object, true);
    }

    @Override
    @NotNull
    protected Object serialize(@NotNull ItemStack object) {
        return object.serialize();
    }

    @Override
    @NotNull
    protected ItemStack deserialize(@NotNull Object object) {
        return ItemStack.deserialize((Map)((Map)object));
    }

    @Override
    protected void serialize(@NotNull ConfigurationSection section) {
        super.serialize(section);
        if (!this.comparisons.getNotDefault().isEmpty()) {
            section.createSection("itemComparisons", this.comparisons.getNotDefault());
        }
    }

    public static abstract class Creator<T extends AbstractItemStage>
    extends StageCreation<T> {
        private static final ItemStack stageComparison = ItemUtils.item(XMaterial.PRISMARINE_SHARD, Lang.stageItemsComparison.toString(), new String[0]);
        @NotNull
        private List<ItemStack> items;
        @NotNull
        private ItemComparisonMap comparisons = new ItemComparisonMap();

        public Creator(@NotNull StageCreationContext<T> context) {
            super(context);
        }

        @Override
        public void setupLine(@NotNull StageGuiLine line) {
            super.setupLine(line);
            line.setItem(6, this.getEditItem().clone(), event -> QuestsPlugin.getPlugin().getGuiManager().getFactory().createItemsSelection(items -> {
                this.setItems((List<ItemStack>)items);
                event.reopen();
            }, this.items).open(event.getPlayer()));
            line.setItem(7, stageComparison.clone(), event -> QuestsPlugin.getPlugin().getGuiManager().getFactory().createItemComparisonsSelection(this.comparisons, () -> {
                this.setComparisons(this.comparisons);
                event.reopen();
            }).open(event.getPlayer()));
        }

        @NotNull
        protected abstract ItemStack getEditItem();

        public void setItems(List<ItemStack> items) {
            this.items = items;
            this.getLine().refreshItem(6, ItemUtils.loreAdd(this.getEditItem(), QuestOption.formatNullableValue(Lang.AmountItems.quickFormat("items_amount", this.items.size()))));
        }

        public void setComparisons(ItemComparisonMap comparisons) {
            this.comparisons = comparisons;
            this.getLine().refreshItemLoreOptionValue(7, Lang.AmountComparisons.quickFormat("comparisons_amount", this.comparisons.getEffective().size()));
        }

        @Override
        public void start(Player p) {
            super.start(p);
            QuestsPlugin.getPlugin().getGuiManager().getFactory().createItemsSelection(items -> {
                this.setItems((List<ItemStack>)items);
                this.context.reopenGui();
            }, Collections.emptyList()).open(p);
        }

        @Override
        public void edit(T stage) {
            super.edit(stage);
            this.setItems(((AbstractCountableStage)stage).getObjects().stream().map(entry -> {
                ItemStack item = ((ItemStack)entry.getObject()).clone();
                item.setAmount(entry.getAmount());
                return item;
            }).collect(Collectors.toList()));
            this.setComparisons(((AbstractItemStage)stage).comparisons.clone());
        }

        @Override
        public final T finishStage(StageController controller) {
            ArrayList<CountableObject<ItemStack>> itemsMap = new ArrayList<CountableObject<ItemStack>>();
            block0: for (int i = 0; i < this.items.size(); ++i) {
                ItemStack item = this.items.get(i);
                int amount = item.getAmount();
                item.setAmount(1);
                for (CountableObject.MutableCountableObject mutableCountableObject : itemsMap) {
                    if (!((ItemStack)mutableCountableObject.getObject()).equals((Object)item)) continue;
                    mutableCountableObject.setAmount(mutableCountableObject.getAmount() + amount);
                    continue block0;
                }
                itemsMap.add(CountableObject.createMutable(new UUID(item.hashCode(), 2478L), item, amount));
            }
            return this.finishStage(controller, itemsMap, this.comparisons);
        }

        protected abstract T finishStage(@NotNull StageController var1, @NotNull @NotNull List<@NotNull CountableObject<ItemStack>> var2, @NotNull ItemComparisonMap var3);
    }
}

