/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.stages.types;

import fr.skytasul.quests.api.QuestsPlugin;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Spliterator;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Locatable {
    default public boolean isShown(@NotNull Player player) {
        return true;
    }

    default public boolean canBeFetchedAsynchronously() {
        return true;
    }

    public static boolean hasLocatedTypes(@NotNull Class<? extends Locatable> clazz, LocatedType ... types) {
        HashSet<LocatedType> toTest = new HashSet<LocatedType>(Arrays.asList(types));
        boolean foundAnnotation = false;
        Class<? extends Locatable> superclass = clazz;
        do {
            LocatableType annotation;
            if ((annotation = superclass.getDeclaredAnnotation(LocatableType.class)) == null) continue;
            foundAnnotation = true;
            for (LocatedType locatedType : annotation.types()) {
                toTest.remove((Object)locatedType);
                if (!toTest.isEmpty()) continue;
                return true;
            }
        } while ((superclass = superclass.getSuperclass()) != null);
        if (!foundAnnotation) {
            QuestsPlugin.getPlugin().getLoggerExpanded().debug("Class " + clazz.getName() + " does not have the @LocatableType annotation.");
            return true;
        }
        return false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface LocatableType {
        @NotNull
        public @NotNull LocatedType @NotNull [] types() default {LocatedType.ENTITY, LocatedType.BLOCK, LocatedType.OTHER};
    }

    public static enum LocatedType {
        BLOCK,
        ENTITY,
        OTHER;

    }

    public static interface Located {
        @NotNull
        public Location getLocation();

        @NotNull
        public LocatedType getType();

        @NotNull
        public static Located create(@NotNull Location location) {
            return new LocatedImpl(location);
        }

        public static class LocatedImpl
        implements Located {
            protected Location location;

            public LocatedImpl(Location location) {
                this.location = location;
            }

            @Override
            public Location getLocation() {
                return this.location.clone();
            }

            @Override
            public LocatedType getType() {
                return LocatedType.OTHER;
            }

            public int hashCode() {
                return this.location.hashCode();
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof LocatedImpl)) {
                    return false;
                }
                LocatedImpl other = (LocatedImpl)obj;
                return other.location.equals((Object)this.location);
            }
        }

        public static interface LocatedBlock
        extends Located {
            @NotNull
            default public Block getBlock() {
                return this.getLocation().getBlock();
            }

            @Nullable
            default public Block getBlockNullable() {
                Location location = this.getLocation();
                if (location == null || location.getWorld() == null) {
                    return null;
                }
                return location.getBlock();
            }

            @Override
            @NotNull
            default public LocatedType getType() {
                return LocatedType.BLOCK;
            }

            @NotNull
            public static LocatedBlock create(@NotNull Block block) {
                return new LocatedBlockImpl(block);
            }

            @NotNull
            public static LocatedBlock create(@NotNull Location location) {
                return new LocatedBlockLocationImpl(location);
            }

            public static class LocatedBlockImpl
            implements LocatedBlock {
                private Block block;

                public LocatedBlockImpl(Block block) {
                    this.block = block;
                }

                @Override
                public Location getLocation() {
                    return this.block.getLocation();
                }

                @Override
                public Block getBlock() {
                    return this.block;
                }

                @Override
                public Block getBlockNullable() {
                    return this.getBlock();
                }
            }

            public static class LocatedBlockLocationImpl
            extends LocatedImpl
            implements LocatedBlock {
                public LocatedBlockLocationImpl(Location location) {
                    super(location);
                }

                @Override
                public Block getBlock() {
                    return this.location.getBlock();
                }

                @Override
                public LocatedType getType() {
                    return LocatedType.BLOCK;
                }
            }
        }

        public static interface LocatedEntity
        extends Located {
            @Nullable
            public Entity getEntity();

            @Override
            @NotNull
            default public LocatedType getType() {
                return LocatedType.ENTITY;
            }

            @NotNull
            public static LocatedEntity create(Entity entity) {
                return new LocatedEntityImpl(entity);
            }

            public static class LocatedEntityImpl
            implements LocatedEntity {
                private Entity entity;

                public LocatedEntityImpl(@NotNull Entity entity) {
                    this.entity = Objects.requireNonNull(entity);
                }

                @Override
                public Entity getEntity() {
                    return this.entity;
                }

                @Override
                @NotNull
                public Location getLocation() {
                    return this.entity.getLocation();
                }

                public int hashCode() {
                    return this.entity.hashCode();
                }

                public boolean equals(Object obj) {
                    if (!(obj instanceof LocatedEntityImpl)) {
                        return false;
                    }
                    LocatedEntityImpl other = (LocatedEntityImpl)obj;
                    return other.entity.equals((Object)this.entity);
                }
            }
        }
    }

    public static interface MultipleLocatable
    extends Locatable {
        public @Nullable Spliterator<@NotNull Located> getNearbyLocated(@NotNull NearbyFetcher var1);

        public static interface NearbyFetcher {
            @NotNull
            public Location getCenter();

            public double getMaxDistance();

            default public double getMaxDistanceSquared() {
                return this.getMaxDistance() * this.getMaxDistance();
            }

            default public boolean isTargeting(@NotNull LocatedType type) {
                return true;
            }

            @NotNull
            public static NearbyFetcher create(@NotNull Location location, double maxDistance) {
                return new NearbyFetcherImpl(location, maxDistance, null);
            }

            @NotNull
            public static NearbyFetcher create(@NotNull Location location, double maxDistance, @Nullable LocatedType targetType) {
                return new NearbyFetcherImpl(location, maxDistance, targetType);
            }

            public static class NearbyFetcherImpl
            implements NearbyFetcher {
                private final Location center;
                private final double maxDistance;
                private final LocatedType targetType;

                public NearbyFetcherImpl(Location center, double maxDistance, LocatedType targetType) {
                    this.center = center;
                    this.maxDistance = maxDistance;
                    this.targetType = targetType;
                }

                @Override
                public Location getCenter() {
                    return this.center;
                }

                @Override
                public double getMaxDistance() {
                    return this.maxDistance;
                }

                @Override
                public boolean isTargeting(LocatedType type) {
                    return this.targetType == null || this.targetType == type;
                }
            }
        }
    }

    public static interface PreciseLocatable
    extends Locatable {
        @Nullable
        public Located getLocated();
    }
}

