/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChatColorUtils {
    private static final Pattern START_WITH_COLORS = Pattern.compile("(?i)^(\u00a7[0-9A-FK-ORX])+");
    private static final Pattern COLOR = Pattern.compile("(?i)\u00a7[0-9A-FK-ORX]");
    private static final Pattern HEX_COLOR = Pattern.compile("(?i)[&\u00a7]#([A-F0-9]{6})");
    private static final Pattern NEWLINE_PATTERN = Pattern.compile("\\\\n|\\{nl\\}");

    private ChatColorUtils() {
    }

    @NotNull
    public static @NotNull List<@NotNull String> wordWrap(@Nullable String rawString, int lineLength) {
        return ChatColorUtils.wordWrap(rawString, lineLength, lineLength);
    }

    @NotNull
    public static @NotNull List<@NotNull String> wordWrap(@Nullable String rawString, int maxLineLength, int criticalLineLength) {
        if (maxLineLength > criticalLineLength) {
            maxLineLength = criticalLineLength;
        }
        if (rawString == null) {
            return Arrays.asList("");
        }
        if (((String)(rawString = NEWLINE_PATTERN.matcher((CharSequence)rawString).replaceAll("\n"))).length() <= maxLineLength && !((String)rawString).contains("\n")) {
            return Arrays.asList(rawString);
        }
        try {
            char[] rawChars = ((String)rawString + " ").toCharArray();
            StringBuilder word = new StringBuilder();
            StringBuilder line = new StringBuilder(maxLineLength);
            String colorsWord = "";
            String colors = "";
            boolean first = false;
            LinkedList<String> lines = new LinkedList<String>();
            int wordLength = 0;
            int lineLength = 0;
            for (int i = 0; i < rawChars.length; ++i) {
                char c = rawChars[i];
                if (c == '\u00a7') {
                    Matcher matcher = START_WITH_COLORS.matcher(((String)rawString).substring(i));
                    if (matcher.find()) {
                        String rawColors = matcher.group();
                        String oldColors = colors;
                        colors = ChatColorUtils.appendRawColorString(colors, rawColors);
                        String toAdd = ChatColorUtils.getColorDifference(oldColors, colors);
                        if (colors.length() >= criticalLineLength) {
                            colors = "";
                        } else {
                            word.append(toAdd);
                        }
                        i += rawColors.length() - 1;
                        continue;
                    }
                    word.append(c);
                    continue;
                }
                if (c == ' ' || c == '\n') {
                    if (lineLength == 0 && (wordLength > maxLineLength || word.length() > criticalLineLength)) {
                        lines.addAll(ChatColorUtils.splitColoredWord(word.toString(), wordLength, maxLineLength, criticalLineLength, colorsWord));
                    } else {
                        int totalLength = (lineLength == 0 ? 0 : lineLength + 1) + wordLength;
                        int totalLengthC = (lineLength == 0 ? 0 : line.length() + 1) + word.length();
                        if (totalLength == maxLineLength && totalLengthC <= criticalLineLength || totalLengthC == criticalLineLength && totalLength <= maxLineLength) {
                            if (lineLength > 0) {
                                line.append(' ');
                            }
                            line.append((CharSequence)word);
                            lines.add(line.toString());
                            line = new StringBuilder(maxLineLength);
                            lineLength = 0;
                            first = true;
                        } else if (totalLength > maxLineLength || totalLengthC > criticalLineLength) {
                            lines.add(line.toString());
                            if (word.length() >= maxLineLength || word.length() >= criticalLineLength) {
                                lines.addAll(ChatColorUtils.splitColoredWord(colorsWord + word.toString(), wordLength, maxLineLength, criticalLineLength, colorsWord));
                                lineLength = 0;
                                line = new StringBuilder(maxLineLength);
                            } else {
                                int textIndex = ChatColorUtils.getFirstTextIndex(word.toString());
                                line = new StringBuilder(maxLineLength);
                                line.append(word.substring(textIndex));
                                lineLength = wordLength;
                                line.insert(0, ChatColorUtils.appendRawColorString(colorsWord, word.substring(0, textIndex)));
                            }
                        } else {
                            if (line.length() > 0 && !first) {
                                line.append(' ');
                                ++lineLength;
                            }
                            first = false;
                            line.append((CharSequence)word);
                            lineLength += wordLength;
                        }
                    }
                    colorsWord = colors;
                    word = lineLength == 0 ? new StringBuilder(colors) : new StringBuilder();
                    wordLength = 0;
                    if (c != '\n') continue;
                    lines.add(line.toString());
                    line = new StringBuilder(maxLineLength);
                    lineLength = 0;
                    word.append(colors);
                    first = true;
                    continue;
                }
                word.append(c);
                ++wordLength;
            }
            if (line.length() > 0) {
                lines.add(line.toString());
            }
            return lines;
        }
        catch (Exception ex) {
            new RuntimeException("An exception occurred while trying to split the string " + (String)rawString + " with max length " + maxLineLength + " and critical length " + criticalLineLength, ex).printStackTrace();
            rawString = "\u00a74ERROR " + (String)rawString;
            return Arrays.asList(((String)rawString).split("(?<=\\G.{4})"));
        }
    }

    @NotNull
    public static String appendRawColorString(@NotNull String original, @NotNull String appended) {
        StringBuilder builder = new StringBuilder(original);
        StringBuilder hexBuilder = null;
        for (int colorIndex = 1; colorIndex < appended.length(); colorIndex += 2) {
            char cc = appended.charAt(colorIndex);
            if (hexBuilder != null) {
                hexBuilder.append('\u00a7').append(cc);
                if (hexBuilder.length() != 14) continue;
                builder = hexBuilder;
                hexBuilder = null;
                continue;
            }
            if (cc == 'x') {
                if (colorIndex + 12 >= appended.length()) continue;
                hexBuilder = new StringBuilder("\u00a7x");
                continue;
            }
            ChatColor sub = ChatColor.getByChar((char)cc);
            if (sub != null) {
                if (sub == ChatColor.RESET) {
                    builder.setLength(0);
                    continue;
                }
                if (sub.isColor()) {
                    builder.setLength(0);
                }
                builder.append(sub.toString());
                continue;
            }
            builder.append('\u00a7').append(cc);
        }
        return builder.toString();
    }

    @NotNull
    private static String getColorDifference(@NotNull String oldColors, @NotNull String newColors) {
        return newColors.startsWith(oldColors) ? newColors.substring(oldColors.length()) : newColors;
    }

    @NotNull
    private static @NotNull List<@NotNull String> splitColoredWord(@NotNull String string, int stringLength, int maxLength, int criticalLength, @NotNull String startColors) {
        String original = string;
        int loops = 0;
        ArrayList<String> split = new ArrayList<String>();
        while (stringLength >= maxLength || ((String)string).length() >= criticalLength) {
            if (loops++ > 1000) {
                throw new RuntimeException("Failed to split a colored string: " + original);
            }
            int colorIndex = ((String)string).indexOf(167);
            if (colorIndex > maxLength || colorIndex == -1) {
                split.add(startColors + ((String)string).substring(0, maxLength));
                string = ((String)string).substring(maxLength);
                stringLength -= maxLength;
                continue;
            }
            int length = 0;
            int previousIndex = -2;
            String colors = startColors;
            Matcher matcher = COLOR.matcher((CharSequence)string);
            while (matcher.find()) {
                if (loops++ > 1000) {
                    throw new RuntimeException("Failed to split a colored string: " + original);
                }
                if ((length += matcher.start() - previousIndex - 2) > maxLength || matcher.start() > criticalLength) {
                    split.add(((String)string).substring(0, previousIndex));
                    string = startColors + ((String)string).substring(previousIndex);
                    startColors = colors;
                    matcher = COLOR.matcher((CharSequence)string);
                    stringLength -= length;
                    length = 0;
                    previousIndex = -2;
                    continue;
                }
                colors = ChatColorUtils.appendRawColorString(colors, matcher.group());
                previousIndex = matcher.start();
            }
            int truncated = 0;
            if ((length += ((String)string).length() - (previousIndex + 2)) >= maxLength) {
                truncated = maxLength + startColors.length();
                if (((String)string).charAt(truncated - 1) == '\u00a7') {
                    --truncated;
                }
                split.add(((String)string).substring(0, truncated));
                string = startColors + ((String)string).substring(truncated);
            } else if (((String)string).length() >= criticalLength) {
                truncated = criticalLength - startColors.length();
                split.add(((String)string).substring(0, truncated));
                string = startColors + ((String)string).substring(truncated);
            }
            stringLength -= truncated;
            startColors = colors;
        }
        split.add((String)string);
        return split;
    }

    private static int getFirstTextIndex(@NotNull String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (i % 2 == 0) {
                if (c == '\u00a7') continue;
                return i;
            }
            if ("0123456789AaBbCcDdEeFfKkLlMmNnOoRrXx".indexOf(c) != -1) continue;
            return i - 1;
        }
        return string.length();
    }

    @NotNull
    public static String translateHexColorCodes(@NotNull String message) {
        Matcher matcher = HEX_COLOR.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + "\u00a7" + group.charAt(1) + "\u00a7" + group.charAt(2) + "\u00a7" + group.charAt(3) + "\u00a7" + group.charAt(4) + "\u00a7" + group.charAt(5));
        }
        return matcher.appendTail(buffer).toString();
    }

    @NotNull
    public static String getLastColors(@NotNull String originalColors, @Nullable String appended) {
        if (appended == null || appended.length() == 0) {
            return originalColors;
        }
        StringBuilder builder = originalColors == null ? new StringBuilder() : new StringBuilder(originalColors);
        StringBuilder hexBuilder = null;
        boolean color = false;
        for (int colorIndex = 0; colorIndex < appended.length(); ++colorIndex) {
            char cc = Character.toLowerCase(appended.charAt(colorIndex));
            if (cc == '\u00a7') {
                color = true;
                continue;
            }
            if (color) {
                color = false;
                if (hexBuilder != null) {
                    if (cc >= '0' && cc <= '9' || cc >= 'a' && cc <= 'f') {
                        hexBuilder.append('\u00a7').append(cc);
                        if (hexBuilder.length() != 14) continue;
                        builder = hexBuilder;
                        hexBuilder = null;
                        continue;
                    }
                    hexBuilder = null;
                    continue;
                }
                if (cc == 'x') {
                    if (colorIndex + 12 >= appended.length()) continue;
                    hexBuilder = new StringBuilder("\u00a7x");
                    continue;
                }
                ChatColor sub = ChatColor.getByChar((char)cc);
                if (sub != null) {
                    if (sub == ChatColor.RESET) {
                        builder.setLength(0);
                        continue;
                    }
                    if (sub.isColor()) {
                        builder.setLength(0);
                    }
                    builder.append(sub.toString());
                    continue;
                }
                builder.append('\u00a7').append(cc);
                continue;
            }
            if (hexBuilder == null) continue;
            hexBuilder = null;
        }
        return builder.toString();
    }
}

