/*
 * Decompiled with CFR 0.152.
 */
package fr.skytasul.quests.api.utils;

import fr.skytasul.quests.api.editors.parsers.EnumParser;
import fr.skytasul.quests.api.localization.Lang;

public enum ComparisonMethod {
    EQUALS('=', Lang.ComparisonEquals),
    DIFFERENT('\u2260', Lang.ComparisonDifferent),
    LESS('<', Lang.ComparisonLess),
    LESS_OR_EQUAL('\u2264', Lang.ComparisonLessOrEquals),
    GREATER('>', Lang.ComparisonGreater),
    GREATER_OR_EQUAL('\u2265', Lang.ComparisonGreaterOrEquals);

    private char symbol;
    private Lang title;
    private static final EnumParser<ComparisonMethod> COMPARISON_PARSER;

    private ComparisonMethod(char symbol, Lang title) {
        this.symbol = symbol;
        this.title = title;
    }

    public char getSymbol() {
        return this.symbol;
    }

    public Lang getTitle() {
        return this.title;
    }

    public boolean isEqualOperation() {
        switch (this.ordinal()) {
            case 0: 
            case 3: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumberOperation() {
        switch (this.ordinal()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean test(double diff) {
        if (diff == 0.0) {
            return this.isEqualOperation();
        }
        if (this == DIFFERENT) {
            return true;
        }
        if (diff > 0.0) {
            return this == GREATER || this == GREATER_OR_EQUAL;
        }
        if (diff < 0.0) {
            return this == LESS || this == LESS_OR_EQUAL;
        }
        return false;
    }

    public static EnumParser<ComparisonMethod> getComparisonParser() {
        return COMPARISON_PARSER;
    }

    static {
        COMPARISON_PARSER = new EnumParser<ComparisonMethod>(ComparisonMethod.class);
    }
}

